---
title: "The BIG List of Video Game Randomizers - Changelog"
permalink: "randomizers-changelog"
snippet: "Every single update ever made to The BIG List of Video Game Randomizers."
---
[🔙 The BIG List of Video Game Randomizers](/randomizers/)

## 2024-05-13

- Open source release.
- Removed TokyoScarab's Mega Man X randomizer for legal reasons.

## 2024-05-09

### Added randomizers

- Advance Wars 2: Black Hole Rising (Self Randomizer)
- Fire Emblem: The Binding Blade (Self Randomizer)
- Fire Emblem: The Blazing Blade (Self Randomizer)
- Ultrakill (ArchipelagoULTRAKILL)

### Other changes

- Added Metroid: Samus Returns to Randovania, and updated its URL.
- Updated Archipelago entry with an external link to a list of additional extensions for it in development.
- Removed Yoshi's Funland for legal reasons.

## 2024-05-05

### Added randomizers

- Dragon's Dogma 2 (0xffa's)
- Kid Chameleon (Level Randomizer)
- Like a Dragon: Infinite Wealth (Zoo's)
- Lunacid (Witchybun Albrekka's)
- Might and Magic VI: The Mandate of Heaven / Might and Magic VII: For Blood and Honor (Anerag's)
- Persona 5 Royal (Screenments's)
- Pokémon Scarlet / Pokémon Violet (Gonzalo's)
- Star Wars: Dark Forces (Showcase)
- Xenoblade Chronicles 3 (Future Redeemed unlock kit balance editor)
- Yoshi's Island (Yoshi's Funland)

### Other changes

- Added Oxide / Super Metroid: Redesign / Digital Cube / Super Metroid: Golden Dawn to ironrusty's randomizers of Super Metroid hacks.
- Added Tunic / Kirby's Dream Land 3 / Celeste 64: Fragments of the Mountain / Zork: Grand Inquisitor / Castlevania (Nintendo 64) / A Short Hike / Yoshi's Island to Archipelago, and removed the corresponding previously-independent entry for Castlevania (Nintendo 64).
- Renamed Ufouria: The Saga and its series to Hebereke, in order to be consistent with the recent release of Hebereke: Enjoy Edition.
- Marked XLuma's Pokémon Scarlet/Violet randomizer as obsolete.
- Other minor changes.

## 2024-03-10

### Added randomizers

- Escape the Backrooms (Reokin's)
- King Arthur: Knight's Tale (Skill Tree Randomizer)
- Legend of Grimrock (Random Dungeon)
- Lies of P (Item Randomizer)
- Lies of P (Shop Item Randomizer)
- Lies of P (Starting Weapon Randomizer)
- Mystical Ninja Starring Goemon (Ancient Cave Starring Goemon)
- Palworld (Overworld Spawn Randomizer)
- Shogun Showdown (Enemy / Boss Randomizer)
- Stardew Valley (Community Center Bundles Randomizer)
- Starfield (Enemy Weapon Randomizer)
- The Elder Scrolls V: Skyrim Special Edition (Alchemy Effects Randomizer, SKSE)

### Other changes

- Added Cliffhanger Redux / Super Zero Mission / Metroid: The Blue Plague to ironrusty's randomizers of Super Metroid hacks.
- Added an unofficial hints mod for some of the Elden Ring randomizers.
- Added an unofficial YUP mod patch for the Fallout: New Vegas Skill Check Randomizer.
- Moved Gensokyo no Nazo to the Touhou section, and fixed its romanization.
- Switched Japanese romanization from international Kunrei-shiki to modern Hepburn, as the Japanese government appears to be in the process of officially phasing out Kunrei-shiki in favor of Hepburn.
- Corrected list of main authors for the main Paper Mario randomizer.
- Updated link to OBSIDIAN.
- Removed link to letsmultiworld.com as it has been broken for months.
- Removed Elden Ring Diablo Style Loot due to pre-randomization in the original version and incomplete coverage in the remastered version.
- Further clarified the list inclusion criteria about randomizers for mods.
- Improved used game name rule for stylized writings.

## 2024-01-21

### Added randomizers

- KuruKuru Kururin (KuruKuruKurandomizer)
- Parasite Eve II (Randomized Eve II)
- Pokémon Mystery Dungeon: Red Rescue Team (Suguivy's)
- Super Mario RPG (Switch) (ObsidianMaker's)
- The Battle of Olympus (Item Randomizer)
- The Legend of Zelda: Majora's Mask 3D (MM3D_Randomizer)

### Other changes

- Added Lingo (Brenton Wildes) / Pokémon Emerald Version / Doom II / Shivers / Heretic / Landstalker: The Treasures of King Nole / Final Fantasy Mystic Quest to Archipelago.
- Updated link to kandowontu's Star Fox randomizer.
- Removed Cactuar's Wizardry randomizers as the website went offline with no known backups.
- Clarified the list inclusion criteria about randomizers for mods and recurring random events.

## 2023-12-02

### Added randomizers

- Age of Mythology: Extended Edition (Steam Workshop - Map Scripts)
- Europa Universalis IV (Randomizable World)
- Europa Universalis IV (Religion Randomizer)
- Fire Emblem: The Sacred Stones (Illusory Dungeon)
- Mega Man X6 (Tweaks Patcher)
- SpongeBob SquarePants: Battle for Bikini Bottom (GameCube) (BfBB AP World)
- SWAT 4 (Infinity)
- Touhou Luna Nights / Record of Lodoss War: Deedlit in Wonder Labyrinth (Ladybug Randomizer)

### Other changes

- Added two obsolete Europa Universalis IV randomizers to the list: Random New World Improvements and its updated version by a different author.
- Updated link to Civilization V map scripts hosted on Steam Workshop with a search by tag instead of by text. 
- Updated links to Final Fantasy VI Worlds Collide and Super Metroid DASH to their new websites.
- Updated link to an older stable version of Pokémon Emerald Cross, since the newer beta version I was previously linking to appear to have been deleted by its author.
- Removed Europa Universalis IV Randomized World, as Mekanisk's Steam account appears to have been deleted along with their mods.
- Removed Europa Universalis IV Simple Random World due to instability.
- Removed Turbulent Eddie's NES Open Random Mode for NES Open Tournament Golf due to inconsistent randomization.
- Clarified the list inclusion criteria, especially regarding randomizers with major gameplay changes.
- Other minor changes and fixes.

## 2023-11-12

### Added randomizers

- Digimon Story Cyber Sleuth: Complete Edition (zeak6464's)
- Final Fight AE CPS2 (Final Fight hack) (FFAEE-C2)
- Kingdom Hearts: Chain of Memories (gaithern's)
- Mass Effect 2 (Legendary Edition) (ME3Tweaks's)
- OpenMW (The Elder Scrolls III: Morrowind open source port) (Fancy Door Randomizer)
- OpenMW (The Elder Scrolls III: Morrowind open source port) (World Randomizer)
- Shadow the Hedgehog (MainMemory & dreamsyntax's)
- Star Fox (kandowontu's)
- Super Mario Bros. Wonder (MH13's)
- System Shock 2 / Secmod (mod) (Sarge945's)
- The Elder Scrolls IV: Oblivion (Leveled Armors and Weapons Randomizer)

### Other changes

- Added AM2R to Randovania.
- Merged Daniel Jianoran's randomizers into a single entry pointing to the their GitHub repository as djrandos.com is being cybersquatted.
- Marked FFAEE, ObHack and Zygoptera's System Shock 2 randomizer as obsolete.
- Removed Zelda Classic quests due to added custom game elements.
- Renamed the Hebereke series to the current official English name Ufouria.
- Many other minor improvements and fixes.

## 2023-10-15

### Added randomizers

- Alien: Isolation (Mission Randomiser)
- Castlevania: Harmony of Dissonance / Bomberman Tournament (HoDBT)
- Castlevania: Symphony of the Night (PlayStation / Saturn) (Area Randomizer)
- CrossCode (Item Randomizer)
- Digimon World 3 (markisha64's)
- Fossil Fighters: Champions (opiter09's)
- Pseudoregalia (spuds's)
- The Ur-Quan Masters (Star Control II open source port) (Infinite Ur Quan Masters)
- Zero Sievert (Gun and Armor Randomizer)
- Cryogenesis / Eris / Escape II / Recovery / Stardust / Nature / V I T A L I T Y / Ascent (Super Metroid hacks) (ironrusty's)

### Other changes

- Added source code to the Kingdom Hearts II Final Mix Door Randomizer.
- Merged SubversionRando with other Super Metroid hacks randomizers by ironrusty.
- Split unofficial Metroid games into 2 separate sub-categories.
- Many other minor improvements.

## 2023-09-19

I created a new official Discord Community server for the list. Check it out!

### Added randomizers

- Custom Robo (PoggieB's)
- Fossil Fighters (opiter09's)
- Haiku, the Robot (Jarlyk's)
- Zelda II: The Adventure of Link (Ellendar's)

### Other changes

- Marked Digshake's Z2Randomizer as obsolete.
- Updated Discord server information.

## 2023-09-04 #2

- Removed reference to the Axiom Verge monster randomizer in v0.6.2.1 of Pozzum's randomizer. It shouldn't have been added in the first place due to its chaotic effects.
- Clarified why Pozzum's Axion Verge randomizer is marked as obsolete despite being the only one on the list.
- Other minor changes.

## 2023-09-04

### Added randomizers

- Bomberman Tournament (fusecv's)
- Dead Rising 2: Off the Record (Fairy With a Pan's)
- Psychonauts (PsychoRando)
- The Guardian Legend (fireball87's)
- The Legend of Heroes: Trails into Reverie (nnguyen259's)
- The Legend of Zelda: Tears of the Kingdom (MelonSpeedruns's)

### Other changes

- Added Tomb Raider / Tomb Raider III to Lost Artefacts's Tomb Raider randomizer. (Only Tomb Raider II was listed before.)
- Added Undertale / Mega Man Battle Network 3 Blue / Muse Dash / Doom (Ultimate) / Terraria to Archipelago.
- Removed The Guardian Legend: Worlds due to reports of unwinnable seeds.
- Marked Micheil Skeens's The Guardian Legend as obsolete.
- Updated links to randomizers unofficially backed up on Discord.

## 2023-07-25

### Added randomizers

- Amnesia: The Bunker (Dog Tag Randomizer)
- Bat Boy (Demo) (Archipelago.BatBoy)
- Breath of Fire (pelador's)
- Dark Souls II: Scholar of the First Sin (Scrambler)
- Final Fantasy IV (pixel remaster) (Falcon Dive)
- Front Mission 5: Scars of the War (Khalid_SA's)
- Inazuma Eleven / Inazuma Eleven 2: FireStorm / Inazuma Eleven 2: Blizzard / Inazuma Eleven 3: Team Ogre Attacks! (Nintendo DS / Nintendo 3DS) (Ultimate Randomizer)
- Inazuma Eleven GO Chrono Stones: Wildfire / Inazuma Eleven GO Chrono Stones: Thunderflash (Pixzer)
- Inazuma Eleven GO: Galaxy (Tinifan's)
- Pokémon Emerald EX Speedchoice (hack) (Map Rando)
- Shadowrun (Osteoclave's)
- System Shock (2023) (Ironman)
- Titanfall 2 (taskinoz's)

## 2023-06-24

Added Halo: Combat Evolved Anniversary (The Master Chief Collection) (Enemy Randomizer).

## 2023-06-19

### Added randomizers

- Age of Empires II: The Age of Kings / Age of Empires II (2013) / Age of Empires II: Definitive Edition (HyperRandom)
- Castlevania: Aria of Sorrow (Reprise)
- Fire Emblem Engage (A Little \*Secret* Ingredient)
- Halo 3 (The Master Chief Collection) (NPC Weapon Randomzier)

### Other changes

- Added DLC Quest / Noita to Archipelago.
- Added Pokémon HeartGold Version / Pokémon SoulSilver Version to Universal Warp Randomizer.
- Updated link to Chrono Trigger Jets of Time to point to the newest version.
- Updated Stardew Valley section, including an unofficial SMAPI compatility fix for More Random Edition.
- Marked LordMewtwo73's Fire Emblem Engage randomizer as obsolete.
- Merged The Legend of Zelda: Ocarina of Time entries that are now integrated as dev forks on the website for TestRunner's.

## 2023-05-10

### Added randomizers

- Advance Wars 2: Black Hole Rising (Ephraim225's)
- Fire Emblem Engage (LordMewtwo73's)
- Mega Man (avvie & JoJoCrusade's)
- Mega Man Battle Network (Legacy Collection) (Undernet-Trader)
- NEO: The World Ends with You (SaltContainer's)
- Yakuza: Like a Dragon (Enemy Randomizer)

### Other changes

- Updated link to Arthurtilly's Super Mario 64 randomizer with newer versions.
- Updated Pokémon Crystal Speedchoice randomizers entries.
- Updated Mega Man Battle Network game names.

## 2023-04-11

- Renamed Die4Ever's StarCraft 2 randomizer to Balance Patch Randomizer.
- Removed Xane Randomizer for Fire Emblem: Mystery of the Emblem, since the author (izumi_niche) deleted it, apparently due to quality issues.
- Removed broken randomizers that were hosted on Heroku, except for tetraly's The Legend of Zelda Web Randomizer which was replaced by its GitHub repository. (The removed entries were obsolete randomizers for Kid Icarus and Pokémon Crystal Speedchoice.)
- Fixed broken links.
- Other minor improvements.

## 2023-04-08

### Added randomizers

- Elden Ring (Fog Gate Randomizer)
- Golden Sun (Valyssa's)
- Ittle Dew 2+ (Extra 2 Dew)
- Pokémon Scarlet / Pokémon Violet (XLuma's)

### Other changes

- Added Blasphemous / Wargroove / Stardew Valley / The Legend of Zelda / The Messenger / Kingdom Hearts II Final Mix / The Legend of Zelda: Link's Awakening DX / Adventure to Archipelago.
- Updated the Pokémon Warp Randomizer entry: The new website no longer requires a Discord account, and can perform the randomization in the browser; a direct link to the source code was added; it no longer has the alternate name "Pokémon Map Randomizer" that was promoted by PointCrow.
- Removed the Octopath Traveler Enemy Randomizer, as it is pre-randomized after all.
- Marked MarvinXLII's Golden Sun randomizer as obsolete.
- Marked ZadenOwer's Pokémon Scarlet / Pokémon Violet randomizer as obsolete.

## 2023-03-27

### Added randomizers

- Dragon Quest III: The Seeds of Salvation (Endymionls's)
- Metroid: Zero Mission (Quantum Deluxe Boogaloo)
- Octopath Traveler (Enemy Randomizer)
- Octopath Traveler II (MarvinXLII's)
- Pizza Tower (Greenhead's)
- Rain World (Enemy Randomizer)
- Streets of Rage 2 / Streets of Rage 2 Syndicate Wars (hack) (SoR2 Level Editor)
- Subnautica (Aci's Drop Randomizer Challenge)
- Super Mario Galaxy / Super Mario Galaxy 2 (thegreatwaluigi's)

### Other changes

- Added Resident Evil 3: Nemesis to BioRand entry.
- Marked gameboy9's Dragon Quest III: The Seeds of Salvation randomizer as obsolete.
- Changed readability of Fire Emblem and Pokémon numbering and grouping.
- Slightly updated the list of exclusion criteria to mention that an external logic tracker does not count as a proper substitute for a randomizer that could be added to the list.

## 2023-03-09

- Clarified game compatibility for randomizers in the Kingdom Hearts series.
- Marked Valaxor's Kingdom Hearts II randomizer as obsolete.
- Merged Pokémon Gen upper subcategory into secondary subcategory.
- Fixed game compatibility list for Universal Pokemon Randomizer ZX.

## 2023-03-06

After further feedback, I decided to include randomizers for old versions of Steam games after all, as the downgrading process, while not official, can be performed in a variety of ways that does not necessarily require technical expertise. Randomizers requiring a game downgrade will be noted accordingly when known.

### Added randomizers

- Chained Echoes (Samupo's)
- Fallout 4 (Crazy's Armor Overhaul and Randomizer + Crazy's Weapon Randomizer + Random Weapon Stats)
- Kingdom Hearts: Critical Mix (Kingdom Hearts PC mod) (Xendra's)
- Shining Force III (Chaos)
- Sonic the Hedgehog (Random Levels Project)
- Sonic & Knuckles Collection (MainMemory's)
- Super Metroid (Map Rando)
- The Elder Scrolls V: Skyrim (World Randomizer)

### Other changes

- Changed the list inclusion/exclusion criteria to match the above.
- Re-added Game Dev Tycoon TotalRandomiser, Half-Life 2 Random Map Creator, and Resident Evil 4 UHD Ultimate Trainer due to the above change.
- Added a backup by Bruno Aguero of gumbenzoin's obsolete Nioh 2 Enemy Randomizer. 
- Fixed dead link to BloodSweatAndCode's Castlevania II: Simon's Quest randomizer.
- Fixed dead link to the Kingdom Hearts III randomizer.
- Updated link to the Shining Force Join Order Randomizer, in favor of the original release forum thread.
- Added note that some of the randomizers for the Dark Souls series may require a game downgrade.
- Other minor changes.

## 2023-01-30

I recently learned of an undocumented Steam feature that allows downloading old versions of games on their platform. While this is great in theory, the steps to do so are technical or require unofficial tools. Either way, this undocumented feature could break at any moment, as it apparently did in the past. As such, I am quite hesitant to include randomizers requiring such downloads on the list, and decided to continue excluding them for the time being, on the grounds that this is most likely not a feature intended for the general public.

### Added randomizers

- Castlevania (Nintendo 64) (apworld)
- Elden Ring (Diablo Style Loot)
- Elden Ring (Elden Loot)
- Live A Live (PinkSwitch's)
- Pokémon FireRed Version / Pokémon CrystalDust (hack) / Pokémon Emerald Version (GBAXG)
- Spyro the Dragon (Requirement Randomizer)
- Spyro: Year of the Dragon (hwd405's)
- Super Metroid Subversion (hack) (SubversionRando)
- The Elder Scrolls V: Skyrim Special Edition (Serpent's Modular Randomizer)
- The Final Fantasy Legend (Chaoseum)

### Other changes

- Changed the list inclusion/exclusion criteria to match the above.
- Updated the Mario & Luigi: Superstar Saga randomizer link to one that does not require a Discord account.
- Added link to OoTMM's source code.
- Renamed Hitman 3 (2021) to its new official name World of Assassination.
- Clarified that the randomizer for Commander Keen: Invasion of the Vorticons is for the shareware version.
- Fixed Pokémon FireRed/LeafGreen incorrectly labeled as upper instead of remakes.
- Other minor changes and fixes.

## 2023-01-02

### Added randomizers

- Dark Souls: Remastered (Roguelike Souls - The Binding of Lordran)
- Dark Souls II: Scholar of the First Sin (Ran-door-mizer)
- Lufia II: Rise of the Sinistrals (added to Archipelago)
- Nioh 2 (Enemy Randomizer)
- Pokémon Emerald Version (Pokémon Emerald Cross)
- Pokémon Scarlet / Pokémon Violet (ZadenOwer's)
- Ratchet & Clank Collection (bordplate's)
- Resident Evil (MediaKite) / Resident Evil 2 (Sourcenext) (BioRand)
- Resident Evil 4 (Item Randomizer)
- The Elder Scrolls V: Skyrim Special Edition (World Randomizer)
- The Legend of Zelda (Ancient Dungeon)
- The Legend of Zelda: Ocarina of Time / The Legend of Zelda: Majora's Mask (OoTMM)
- Yo-kai Watch (YKWrandomizer)

### Other changes

- Added revised English translation by FlamePurge for Final Fantasy V: Ancient Cave.
- Fixed Archipelago references for Hollow Knight and Metroid Dread missing under their respective series.
- Fixed Dark Souls II: Scholar of the First Sin entries incorrectly referencing the original Dark Souls II instead.
- Updated links to the Classic REbirth mods.

## 2022-11-20

### Added randomizers

- Grandia HD Remaster (Etsuna's)
- Quest for Glory I: So You Want to Be a Hero (EGA) (Rainault's)
- Super Mario World / Pokémon Red Version (international) / Pokémon Blue Version (international) / Hylics 2 / Overcooked! 2 / Zillion (added to Archipelago)
- The Elder Scrolls III: Morrowind (DRIP)

### Other changes

- Updated the Tommadness & thundrio's Kingdom Hearts II randomizer entry with the new website and added compatibility with HD 2.5 ReMix version.
- Renamed the Dark Souls III Static Item Randomizer to Static Item and Enemy Randomizer.
- Marked Final Fantasy Deep Dungeon as obsolete.
- Renamed SodiumEyes's Pokémon Stadium 2 randomizer entry to Rental Moveset Randomizer.
- Added additional authors to the Final Fantasy (pixel remaster) randomizer by the authors' request.

## 2022-11-07

### Added randomizers

- Alundra (Dinopony's)
- An Untitled Story (Mokesmoe's)
- Blasphemous (Item and Enemy Randomizer)
- Chibi-Robo! (JBDdev's)
- Deltarune (Deltarando + Chapter 2 Encounter Randomizer)
- Shin Megami Tensei (spannerisms's)
- Ultima IV: Quest of the Avatar (PC) (Fenyx4's)

### Other changes

- Updated link to AECX's The Legend of Zelda: Twilight Princess Randomizer.
- Renamed the "Doom engine" subcategory for multi-world randomizers to "id Software engines" to better reflect its content.
- Fixed missing author for the Lego Star Wars: The Complete Saga randomizer.
- Updated the exclusion criteria to allow randomizers limited to a specific game mode, as long as it's for all maps/levels within that game mode.
- Minor formatting fixes.

## 2022-10-31

### Added randomizers

- Mario & Luigi: Superstar Saga (jamesbrq's)
- Pokémon FireRed Speedchoice (hack) (Official)
- Pokémon Emerald Speedchoice (hack) (Official)
- Pokémon Emerald EX Speedchoice (hack) (Official)
- S.T.A.L.K.E.R.: Shadow of Chernobyl (Simple Randomizer)
- Shivers (GodlFire's)
- Tunic (SilentDestroyer's)
- Wolfenstein 3D / Spear of Destiny / Super 3D Noah's Ark (added to OBSIDIAN)

### Other changes

- Marked the Tunic Item Randomizer as obsolete.
- Marked LtSquigs's Crystal Project randomizer as obsolete since the author will no longer maintain it now that the main game contains a built-in one.
- Renamed The Ultimate Doom to Doom (Ultimate) following Bethesda's new naming convention for the Doom series.
- Merged the duplicate entry for the Pokémon Crystal Item Randomizer with the Speedchoice hack.
- Updated the Universal Pokemon Randomizer - Speedchoice entry by removing the Pokémon Crystal/Emerald Speedchoice hacks from it since they are now maintained independently, and renamed it to Official to avoid confusion and for consistency.
- Removed the obsolete note about where to find the Pokémon Speedchoice hacks.
- Renamed the Lizard randomizer to Official for consistency.
- Reorganized the Mario subseries.
- Updated the Digimon World 2 randomizer entry with current information.

## 2022-09-25

### Added randomizers

- Final Fantasy VI (Beyond Chaos CE)
- Final Fantasy VI (pixel remaster) (Kefka Rush)
- Final Fantasy X/X-2 HD Remaster (Final Fantasy X HD Randomizer Pack)
- Pikmin 2 (kurumizome's)
- Pokémon Crystal Version / Pokémon Crystal Speedchoice (hack) (Map Randomizer)
- Pokémon Gen IV remakes / Gen V secondary (Map Randomizer)

### Other changes

- Added Metroid Dread to Randovania.
- Added Pokémon Gen III upper and Pokémon White Version 2 compatibility with the Universal Map/Warp Randomizer.
- Standardized the Pokémon Gen subcategories names into primary / secondary / upper / remakes.
- Added new homepage URL for Randovania.
- Marked Duke Nukem 3D Map Order Randomizer as obsolete.
- Marked Final Fantasy VI Beyond Chaos EX as obsolete.
- Fixed the spelling of "Visual Studio Community 2019".

## 2022-09-09

### Added randomizers

- Golden Sun: The Lost Age (Karanum's)
- Pokémon Emerald Version (Pokemon Emerald Rogue)
- Pokémon Gen VIII remakes (Imposter's Ordeal)
- The Final Fantasy Legend (eclipseyy's)
- The Legend of Zelda: A Link Between Worlds (Rick Fay's)
- The Legend of Zelda: Link's Awakening (Nintendo Switch) (Owen-Splat's)
- Vagrant Story (ChaoticBrave's)	

### Other changes

- Restored the obsolete Donkey Kong 64 Loading Zone Randomizer to the latest version thanks to an official backup provided by the author theballaam96.
- Marked SanGawku's Pokémon Gen VIII remakes randomizer as obsolete due to reports of it not working on the latest game version.
- Marked marvin's Golden Sun: The Lost Age randomizer as obsolete.
- Relabelled and marked Kevin Marsolais's original The Legend of Zelda: A Link Between Worlds randomizer as obsolete.
- Relabelled and marked Kevin Glan9's original The Legend of Zelda: Link's Awakening (Nintendo Switch) randomizer as obsolete.
- Fixed Fire Emblem game numbering for Yune.
- Corrected the fact that Archipelago integration with the Final Fantasy, Rogue Legacy and Timespinner randomizers does not use the latter's randomization but Archipelago's.
- Minor improvement to links to randomizers by NBoroKobo.
- Updated the section at the end of the list about creating a randomizer.

## 2022-08-18

### Added randomizers

- Keroro RPG: Kishi to Musha to Densetsu no Kaizoku (Dawnbomb's English Patch + Optional Randomizer)
- Unreal Gold (Die4Ever's)

### Other changes

- Updated the Wizardry randomizers link to HTTPS.

## 2022-08-17

### Added randomizers

- Duke Nukem 3D / Ion Fury / Shadow Warrior / Blood / PowerSlave (PC) (Build Engine Randomizer)
- Final Fantasy X/X-2 HD Remaster (FFX-2 Remaster Randomizer)
- Jurrasic Park (Super NES) (Yoshifanatic1's)
- Kirby 64: The Crystal Shards (jesusyoshi54's)
- Mega Man X3 / Zero Project (hack) (Item Randomizer)
- The Legend of Zelda: Ocarina of Time (Ship of Harkinian)
- Wizardry: Proving Grounds of the Mad Overlord (NES) / Wizardry II: The Knight of Diamonds (NES) / Wizardry III: Legacy of Llylgamyn (NES) (Cactuar's)

### Other changes

- Added Donkey Kong Country 3: Dixie Kong's Double Trouble and Dark Souls III to Archipelago.
- Renamed Elden Ring's Key Item Randomizer to Item and Enemy Randomizer.
- Removed Nyaaaa2314's Fire Emblem Awakening Class-Skill-Randomizer since it has been deleted with no known backups.
- Removed the unofficial web version of Z2Randomizer since it is now offline and was out of date.
- Replaced the Donkey Kong 64 Loading Zone Randomizer with a v1.0 backup since v1.1 has no known backups, and marked it as obsolete.
- Fixed Castlevania: Symphony of the Night being miscategorized.
- Updated/fixed multiple stale links, and updated randomizer names accordingly when applicable.

## 2022-07-25

### Added randomizers

- Broforce (Alex Neargarder's)
- Digimon World 2 (GlorySeeker & acemon33's)
- Final Fantasy II (Fast Food Tour Randomizer)
- Fire Emblem: New Mystery of the Emblem (Raddomizer)
- Kirby and the Forgotten Land (Toranix's)
- Mega Man 2 (Randomizer 2)
- Mega Man 7 (Endless / Rainbow Session Randomizer)
- The Elder Scrolls V: Skyrim Special Edition / The Elder Scrolls V: Skyrim VR (ToxiRandomizer)
- The Sims 4 (NPC Skill Randomizer)

### Other changes

- Clarified the location of the Lego Star Wars: The Complete Saga randomizer
- Added link to a partial source code of RainbowSprinklez's Donkey Kong randomizers
- Marked duckfist's Mega Man 2 randomizer as obsolete.

## 2022-07-17

### Added randomizers

- Baldur's Gate / Baldur's Gate: Enhanced Edition / Baldur's Gate II: Shadows of Amn / Baldur's Gate II: Enhanced Edition (Enemy Randomizer)
- Lego Star Wars: The Complete Saga
- Metroid The Threat Never Ends (fangame) (DodoBirby's)
- PlantsVsZombies.NET (Plants vs. Zombies unofficial PC port) (Andree's)
- Terraria (Flag Randomizer)
- The Legend of Zelda: Ocarina of Time / The Legend of Zelda: Ocarina of Time Master Quest (mracsys's)
- Tunic (Item Randomizer)
- Zombies Ate My Neighbors (Genesis) (Zombies Ate My Roguelike)

### Other changes

- Added game/mod compatibility for the Baldur's Gate series entries Item Randomiser and Sword Coast Stratagems.
- Fixed the Diablo II mod generator entry incorrectly stating compatibility with the original game instead of Diablo II: Resurrected.
- Removed Fire Emblem Awakening's Class-Skill-Randomizer by Nyaaaa2314 due to it being deleted with no known backups.
- Minor fix to the D2 Mod Maker entry.

## 2022-06-22

- Added Pokémon FireRed/LeafGreen Version compatibility to the Pokémon Type Chart Randomizer.
- Minor cosmetic change when explaining acronyms in the Pokémon section.

## 2022-06-21

- Added all games currently supported by the Pokémon Type Chart Randomizer, now covering Gen I, Gen II and most of Gen III.
- Fixed Pokémon Crystal Version not correctly labeled for Gen II.
- Updated instructions on how to get Pokémon Speedchoice releases.

## 2022-06-20

### Added randomizers

- Lightning Returns: Final Fantasy XIII (part of Bartz24's 2021 randomizers)

### Other changes

- Added officially-supported mods for the Deus Ex randomizer.
- Added sub-series grouping for select series.
- Added Generation acronyms for core Pokémon games.
- Added Fire Emblem game numbering.
- Clarified game versions for the Mega Man Battle Chip Challenge, Pokémon Red/Blue Version and Tetris NES randomizers.
- Added note that a Discord account is required to set up Bartz24's 2021 Final Fantasy XIII randomizers.
- Minor change to the ordering of entries within a series.

## 2022-06-13

I have added the randomizer name, or the primary creators' names if the former is too generic, for every single randomizer in the list instead of only a subset. Let me know if any correction is required.

### Added randomizers

- Berwick Saga: Lazberia Chronicle Chapter 174 (Editor & Randomizer)
- Diablo II (Mod generator)
- Final Fantasy XIII (Steam) / Final Fantasy XIII-2 (Steam) (Bartz24's 2021)
- Final Fantasy Tactics (Rumble: Chaos: >>The Crashdown<< REMAKE)- Fire Emblem: Three Houses (Randomizer Custom Build)
- Fire Emblem: Three Houses (Randomizer Custom Build)
- Fire Emblem: Thracia 776 (Kalieum's)
- Kirby Star Allies (firubii's)

### Other changes

- Added Chex Quest 3 (fangame) / Hacx / Harmony (fangame) / Strife to OBSIDIAN.
- Fixed links to FERandomizer and Ephraim's Fire Emblem: The Blazing Blade randomizer. Special thanks to Klokinator for the re-uploads!
- Added Total War: Rome Remastered compatibility with the Rome: Total War randomizer.
- Updated entries in the Ori series.
- Marked the original Final Fantasy Tactics Rumble Chaos Crashdown as obsolete.
- Clarified download link locations of randomizers hosted on speedrun.com.
- Minor URL changes for some GitHub links.

## 2022-05-29

### Added randomizers

- Final Fantasy Mystic Quest (wildham's)

### Other changes

- Added The Witness, Sonic Adventure 2 and StarCraft II to Archipelago, and clarified compatibility with other randomizers on the list.
- Fixed dead link to SHFFL, which became drewlith's Super Smash Bros. Melee Randomizer.
- Added link to the source code of karafruit's fork of The Legend of Zelda: A Link to the Past randomizer.
- Clarified that randomizers located behind paywalls will not be added to the list for the foreseeable future.

## 2022-05-23

### Added randomizers

- Dark Cloud (Chest Randomizer + Enemy Randomizer)
- Dark Cloud 2
- Kingdom Hearts HD 1.5 + 2.5 ReMix (Birth-by-Sleep-Randomizer)
- New Super Mario Bros. Wii

### Other changes

- Marked pk3DS as obsolete.
- Minor link update to Universal Pokemon Randomizer ZX.

## 2022-05-18

### Added randomizers

- Crystal Project
- Final Fantasy V (pixel remaster)
- Super Smash Bros. Ultimate (WoL Randomizer)

### Other changes

- Complete overhaul of Archipelago's entry, including adding Slay the Spire, Risk of Rain 2, VVVVVV, Raft, Super Mario 64 and Meritous as randomized games.
- Updated link to the Kingdom Hearts II Final Mix Door Randomizer to one with documentation.

## 2022-05-07

### Added randomizers

- Elden Ring (Summon Randomizer)
- Factorio (Official Mod Portal - Randomizers)
- Fallen Enchantress
- Fallout 4 (Randomized Enemy Weapons)
- Kingdom Hearts II Final Mix (Door Randomizer)
- The Elder Scrolls IV: Oblivion (ddmlink's)
- The Elder Scrolls V: Skyrim Special Edition (Randomized Birthstones)
- The Legend of Zelda: A Link to the Past (karafruit's)
- The Legend of Zelda: A Link to the Past (Overworld Randomizer)

### Other changes

- Removed Rogue Legacy from Archipelago, and put it as its own independent entry.
- Added The Legend of Zelda: Ocarina of Time Master Quest to Archipelago.
- Replaced Hollow Knight Randomizer 3 with Randomizer 4, including the multiplayer add-on and the recommended mod manager.
- Removed The Elder Scrolls random start mods.

## 2022-05-01

### Added randomizers

- Final Fantasy Tactics Advance (TojiKitten's)
- Kingdom Hearts III
- Resident Evil 4 (Enemy/Merchant Randomizer)
- Silent Hill 4: The Room
- Subnautica (Transition Randomiser)
- Zillion
- Super Metroid / The Legend of Zelda: A Link to the Past (SMZ3 Cas’ Randomizer)

### Other changes

- Added Rotation (Super Metroid hack) conversion tool to VARIA entry.
- Updated link to Sepukkake's Bloodborne Enemy and Item Randomizer to an unofficial re-upload, since the original had been deleted.
- Updated RE_Duke's Resident Evil 2 randomizer entry to its new name "Claire A - Leon B".
- Since ducathan salt merged their Cave Story / Cave Story+ randomizer into Randovania and is now exclusively updating it there, both entries have been merged and moved under Multi-series.
- Added Hollow Knight to Archipelago.

## 2022-03-30

### Added randomizers

- Cave Story (Doukutsu Randamu)
- Commander Keen: Invasion of the Vorticons
- Doom Eternal (Horde Mode Randomizer)
- Elden Ring (Item and Param Randomiser + Key Item Randomizer)
- Fallout 4 (Bobblehead Randomizer)
- Miitopia
- OpenRCT2 (RollerCoaster Tycoon 2 fan recreation)
- Paper Mario (Icebound777's)
- Project Wingman
- Sifu

### Other changes

- Updated RandoBlazer with the web version containing the most recent changes.
- Minor description fixes.

## 2022-02-26

### Added randomizers

- Crusader Kings II (Holy Fury Map Generator)
- Resident Evil 3: Nemesis (Sourcenext) (New RE3 Randomizer)

### Other changes

- Updated link to RE_Duke's Resident Evil 2 (Sourcenext) randomizer.
- Restored Dchaps's BIO2 RNDX and to a more recent version thanks to a backup provided by RE_Duke, added extra instructions, and marked it as obsolete.
- Updated link to the old Crusader Kings II randomizer, and marked it as obsolete.
- Fixed Dicey Dungeons Random Equipment not properly added to the main list.
- Reverted Illusion of Gaia series' name back to Soul Blazer, as the "Illusion of Gaia 2" reference in Terranigma turned out to be inconsistent among the various international releases of the game.

## 2022-02-07

I decided to partially reverse back my decision from December 2020 about official randomizers. Specifically, randomizers made by creators of the original game are now allowed for inclusion if they are not included with it.

### Added randomizers

- Castlevania: Circle of the Moon
- Castlevania: Harmony of Dissonance
- Dicey Dungeons (Random Equipment)
- Diddy Kong Racing
- Resident Evil (MediaKite)
- Resident Evil 2 (Sourcenext) (RE_Duke's)
- Super Smash Bros. Melee (SHFFL)
- The Legend of Zelda: Breath of the Wild (Wii U) (Randomized Leveled Chests)

### Other changes

- Added Rogue Legacy to the list of games randomized by Archipelago.
- Replaced broken link to Final Fantasy III randomizer with its source code.
- Replaced broken links to the Golden Sun series randomizers with backups.
- Removed BIO2 RNDX, Dchaps's Resident Evil 2 (Sourcenext) randomizer, due to the download link no longer working with no known backups.
- Put back the Lizard randomizer on the list due to the above change, and with a new URL.
- Updated the "What is this list" section with the above change.

## 2022-01-22

### Added randomizers

- Pokémon Brillant Diamond / Pokémon Shining Pearl
- Resident Evil 4
- Soldier of Fortune II: Double Helix - Gold Edition
- Sonic CD

### Other changes

- Updated Kid Randomicus entry at the author's request.

## 2021-12-29

### Added randomizers

- Diablo II (D2 Mod Maker)
- Kid Icarus (Kid Randomicus)
- Spelunky 2
- The Legend of Zelda: Breath of the Wild (Wii U) (Waikuteru's)
- The Legend of Zelda: Breath of the Wild (Switch) (Waikuteru's)

### Other changes

- Added Pokémon Platinum Version to the list of supported games for the Universal Map/Warp Randomizer.
- Added warning about downgrading Minecraft: Java Edition.
- Marked the original Kid Icarus randomizer as obsolete.

## 2021-12-18

### Added randomizers

- Bravely Default II
- Fallout: New Vegas (World Randomizer)
- Final Fantasy (pixel remaster)
- Final Fantasy II
- Link: The Faces of Evil / Zelda: The Wand of Gamelon
- Pokémon Ruby Version / Pokémon Sapphire Version / Pokémon FireRed Version / Pokémon LeafGreen Version / Pokémon Emerald Version (Reasonable Randomizer)
- Pokémon Platinum Version (Entrance Randomizer)
- The Elder Scrolls IV: Oblivion

### Other changes

- Updated link to the Mario Kart 64 randomizer.
- Minor update to the link for the Ender Lilies: Quietus of the Knights randomizer.
- Gave Subnautica Randomiser Remade its proper name.
- Clarified thet Metroid Planets is a fan recreation.

## 2021-11-29

### Added randomizers

- Jade Cocoon: Story of the Tamamayu
- Pac-Man World 2
- Pokémon Colosseum / Pokémon XD: Gale of Darkness (Pokemon NGC Rando)
- Pokémon Emerald Version (pokeemerald warp randomizer, obsolete)
- Pokémon Red Version / Pokémon Blue Version (RAMdomizer, obsolete)
- Sin of Mana (Trials of Mana hack)
- Snowboard Kids
- The Legend of Zelda: Breath of the Wild

### Other changes

- Added Super Metroid and Secret of Evermore to Archipelago entry.
- Updated the older Pokémon Colosseum / Pokémon XD: Gale of Darkness randomizer entries and marked them as obsolete.
- Marked Wings of Time as obsolete.

## 2021-10-30

### Added randomizers

- Pokémon Conquest
- Pokémon Emerald Version (Universal Map/Warp Randomizer)
- The Bugs Bunny Crazy Castle

### Other changes

- Modified description of Archipelago to add that it now integrates with existing randomizers.

## 2021-10-15

### Added randomizers

- Final Fantasy IX (Stiltzkin's Bag)
- Final Fantasy IX (﻿VVs Randomizer)
- Monster Hunter: World
- Monster Rancher 2
- Quake II (Campaign Randomizer)

### Other changes

- Updated RandoQ link to a newer version.
- Fixed Star Fox 64 randomizer link.
- Updated Qhimm.com forums links to HTTPS.

## 2021-10-03

### Added randomizers

- Final Fantasy IV (pixel remaster)
- Mega Man Battle Chip Challenge
- Ogre Battle: The March of the Black Queen
- The Legend of Zelda: Link's Awakening (Nintendo Switch)

## 2021-09-22

### Added randomizers

- The Legend of Zelda: A Link to the Past/Four Swords

### Other changes

- Updated Archipelago entry with The Legend of Zelda: Ocarina of Time support and note about non-randomized integrations.
- Clarified that JamSnack's Terraria randomizer requires tModLoader.
- Minor fixes to game name criteria section.

## 2021-09-12

### Added randomizers

- Ender Lilies: Quietus of the Knights
- Star Fox 64

### Other changes

- Updated the Diablo II randomizer entry with a newer version and a Discord invite for support.

## 2021-09-02

### Added randomizers

- Milon's Secret Castle
- Pokémon Crystal Version / Pokémon Crystal Speedchoice (hack) (Type Chart Randomizer)
- Super Mario Bros. 2 (MaCobra52's)
- Undertale

### Other changes

- Clarified randomizer definition wording, especially the part related to the new exclusion from the previous update.

## 2021-08-23

This update comes with a major change to the definition of what counts as a randomizer. More precisely, a randomizer may not force its user to apply any major change that is not designed to accomodate the randomization of the original game data.

This change is to prevent the list from being bloated with a limitless supply of randomizer variants and total conversion mods, an issue which was growing at an exponential rate. This was especially problematic for classic id Software games due to their extensive modding heritage, allowing for easy remixes and extensions of other related mods.

While this means that some fan favorites like Complex DooM are being delisted, this also has the advantage of keeping the list focused on what matters the most for me and the portion of randomizers' fans that I try to cater to: fresh, vanilla-like experiences of our favorite games.

Note that the main games affected with this change so far are The Ultimate Doom, Doom II, Heretic, Quake and Quake II. I have made a [public backup of all the delisted entries](https://pastebin.com/XCfGyKMc), for those curious.

### Added randomizers

- Dragon's Dogma: Dark Arisen
- Salt and Sanctuary
- Super Mario Bros. 2 (Door Randomizer)
- Doom II / Final Doom (The Populator)
- The Ultimate Doom / Heretic (MOShuffle)

### Other changes

- Added the requirement for randomizers to not force major changes unrelated to the randomization of original game data, and removed all identified entries that are no longer in scope. (See above for details.)
- Marked Rydel's Reshuffler for EarthBound as obsolete.
- Marked ORO-RANDOM-DOOM as obsolete.
- Fixed links to the Improved Anvil mods for Baldur's Gate II.

## 2021-08-03

### Added randomizers

- Kingdom Hearts II Final Mix (Tommadness and thundrio's)

### Other changes

- Restored Terranigma's randomizer entry now that it is functional again.
- Added Subnautica compatibility to Archipelago.
- Added Metroid Prime compatibility to Randovania, and updated URL accordingly.
- Marked BashPrime's Metroid Prime randomizer as obsolete.
- Removed multiworld requirements information as it was getting problematic to keep up-to-date, and are now well documented in the documentation of each applicable entries.
- Minor simplification of the non-conformance criteria.

## 2021-07-25

### Added randomizers

- Mario Kart 64
- Metroid Fusion
- Paper Mario
- StarCraft II

### Other changes

- Reordered entries under Metroid so that Metroid: Zero Mission appears immediately after the original Metroid.
- Updated JSRF: Jet Set Radio Future randomizer link to version 3b3, and put back notice that the related the Discord server may contain future releases.
- Updated entry for PyramidK's Resident Evil 3: Nemesis randomizer with newer version.

## 2021-06-16

### Added randomizers

- Fable - The Lost Chapters
- Fable Anniversary
- Final Fantasy XII The Zodiac Age (Open World Randomizer)
- Subnautica (Raqzas's)

### Other changes

- Marked Stephen England's Subnautica randomizer as obsolete.

## 2021-06-13

### Added randomizers

- Civilization VI (Random Religions)
- Kingdom Hearts HD 1.5 + 2.5 ReMix (KHPCSpeedrunTools)
- Landstalker: The Treasures of King Nole
- Shining Force II (Shining Chaos Prelude)
- Uncharted Waters: New Horizons

### Other changes

- Marked StraySouls for Dark Souls III as obsolete with a warning about not randomizing bosses to prevent softlocks.

## 2021-06-03

### Added randomizers

- Banjo-Kazooie
- Donkey Kong 64 (2dos's 2021)
- Final Fight Anniversary Edition (Final Fight hack)
- Pretty Soldier Sailor Moon
- Streets of Rage 4
- The Ultimate Doom / Doom II / Final Doom / Heretic / Hexen: Beyond Heretic (OBSIDIAN)

### Other changes

- Removed the Terranigma randomizer TerraFluky as it is no longer functional.
- Marked OBLIGE as obsolete.
- Added warning that the Donkey Kong 64 Loading Zone Randomizer requires a special emulator.

## 2021-05-17

### Added randomizers

- Blade of Darkness (Gorentity Mod with Random Enemy Creator)
- The Legend of Heroes: Trails of Cold Steel III
- The Ultimate Doom / Doom II (Vandomizer)

### Other changes

- Updated Archipelago entry following added support for Factorio and Minecraft: Java Edition.
- Fixed dead link to DrunkWario's Dead Rising randomizer.
- Removed Raz0r's Resident Evil 4 randomizer as the required game version is no longer available.
- Removed outdated requirement for the Kingdom Hearts II Final Mix randomizer now that it works with the PC version.
- Minor description edit for tools with bundled randomizers.

## 2021-05-07

### Added randomizers

- Dragon Quest VIII: Journey of the Cursed King (Nintendo 3DS)
- The Legend of Zelda: A Link Between Worlds

### Other changes

- Marked the original Universal Pokemon Randomizer as obsolete, and restructured the speedchoice variant as a separate entry.

## 2021-04-27

### Added randomizers

- Dragon Quest III: The Seeds of Salvation (Super NES)
- SteamWorld Dig
- SteamWorld Dig 2
- The Legend of Zelda: Skyward Sword

### Other changes

- Updated ddrand to v0.2.0 (still a mirror).

## 2021-04-22

### Added randomizers

- Breath of Fire III
- Quest 64
- SpongeBob SquarePants: Battle for Bikini Bottom / The SpongeBob SquarePants Movie / Scooby-Doo: Night of 100 Frights

### Other changes

- Updated link of the Mega Man: The Wily Wars randomizer to one that does not require a Discord account.
- Updated link of ddrand to a mirror, as the original GitHub repository is no longer available.

## 2021-03-25

### Added randomizers

- Doom Eternal
- EarthBound (PK Scramble)
- Hades
- Kartia: The Word of Fate
- Mass Effect 2
- Mega Man: The Wily Wars
- Resident Evil 3: Nemesis (EA Taiwanese)
- The Elder Scrolls II: Daggerfall (Random Starting Dungeon)
- The Legend of Zelda: Ocarina of Time 3D

### Other changes

- Updated the Hitman 2 (2018) randomizer entry, now that it switched game compatibility with Hitman 3 (2021) instead.
- Marked The Elder Scrolls II: Daggerfall Starting Dungeon Randomizer as obsolete.
- Added a debug weapon nerf mod for NVRNG.

## 2021-03-15

### Added randomizers

- Pokémon Rejuvenation (fangame)

### Other changes

- Updated Hollow Knight randomizer entry to v3.
- Updated Final Fantasy V Ancient Cave English translation patch link to v0.8.
- Fixed dead link to BashPrime's Metroid Prime randomizer.
- Updated randomizer entries hosted on CodePlex, including linking to the Internet Archive Wayback Machine instead in anticipation of CodePlex Archive's planned shut down next July.
- Updated a bunch of links from HTTP redirects.
- Removed link to Truthkey's Kingdom Hearts II Final Mix randomizer, as it was deleted by its author.

## 2021-03-12

### Added randomizers

- Double Dragon II: The Revenge (NES)
- Pokémon Stadium 2 (RainbowSprinklez's)
- Super Smash T.V.
- The Little Mermaid
- The Messenger

### Other changes

- Added Crash Bandicoot: The Wrath of Cortex compatibility with Mod Crate Loader.
- Added multiplayer notice to Roman971's The Legend of Zelda: Ocarina of Time randomizer.

## 2021-02-03

### Added randomizers

- Bloodstained: Ritual of the Night (Randomization Generator, Randomizer Tweaks and True Randomization Script)
- Bravely Default / Bravely Second: End Layer
- Divinity: Original Sin 2 - Definitive Edition
- Fallout: New Vegas (NVRNG)
- The Legend of Zelda: A Link to the Past (Door Randomizer + 2 obsolete ones)

### Other changes

- Clarified and standardized Turok's game name and version.
- Marked Pokémon Crystal Speedchoice Key Item Randomizer as obsolete.

## 2021-01-31

### Added randomizers

- Donkey Kong (Randomized Edition)
- Turok: Dinosaur Hunter (2015)

### Other changes

- Updated URL to BloodSweatAndCode's Castlevania II: Simon's Quest randomizer.
- Marked Bynine's Dragon Quest Monsters 2 randomizer as obsolete.

## 2021-01-20

### Added randomizers

- Castlevania III: Dracula's Curse
- Super Metroid (World Randomizer)

### Other changes

- Added multiplayer notice for The Legend of Zelda: Oracle of Ages/Seasons randomizer.
- Updated the Axiom Verge randomizer with a download link to a version containing an unbalanced monster randomizer prior to its removal.
- Marked the Axiom Verge randomizer as obsolete, as a new version is now part of the main game.

## 2021-01-06

### Added randomizers

- The Legend of Zelda: A Link to the Past (the outdated Bonta0's Multiworld)
- Ultima VI: The False Prophet (Super NES)

### Other changes

- Updated the Super C randomizer entry with a permalink.
- Updated the links to the main Final Fantasy randomizers for NES and PSP.
- Complete overhaul of entries for multiworld-compatible randomizers.
- Removed links to the source code of TestRunner's Ocarina of Time randomizer as they are now on the website.

## 2020-12-26

### Added randomizers

- Adventure Island II
- Dwarf Fortress (Random plant creation script + Random Raw Scripts)
- Final Fantasy Legend II
- Ori and the Will of the Wisps
- Phantasy Star IV: The End of the Millennium (Profound Disorder)
- Resident Evil 4 (Ultimate HD Edition)
- The World Ends with You

### Other changes

- Updated the Super C randomizer link to the latest version.
- Minor link updates for the Final Fantasy V Career Day, Mega Man X, Ori and the Blind Forest and the old Phantasy Star IV randomizers.
- Removed PerfectWorldDF, as it's not a randomizer for Dwarf Fortress after all.

## 2020-12-15

### Added randomizers

- Legend of Grimrock 2
- Quake II
- Star Wars Jedi Knight: Jedi Academy
- Super C (NES) (SpiderDave's)

### Other changes

- Added name, work-in-progress Windows port and source code of StarsMmd's Pokémon Colosseum / Pokémon XD: Gale of Darkness.
- Fixed typo in Stardew Valley game name.
- Minor fix to the order of the Cave Story randomizers.
- Updated all Discord invite links from discord.gg to discord.com to avoid needless redirection.
- Clarified in the bottom section that randomizers are about randomly arranging game data rather than simply adding randomness to a game, and that their randomization coverage must be complete.
- Added Scenario Generator as reference for an interesting ruleset generator.

## 2020-12-11

This update comes with a few major changes as to what constitutes a valid entry in the list.

First, from now on, I will consider all official randomizers as being out of scope, reverting the change I did a year ago on this regard. I came to the conclusion that while there is value for including a list of games that had randomization features added post-release or that are exclusive to specific versions only, I realized that this was almost impossible to track for games that receive or received frequent updates, and I was getting more and more uncomfortable with the idea of a community-driven project on my website effectively being used as free advertisement by game publishers. As such, they have been removed. This includes Yoku's Island Express despite the randomizer feature being hidden in a Steam beta branch, and Lizard despite the randomizer being a separate tool as it is from the same author as the main game and advertised on the game's website.

Second, I will now consider randomizers that worked on old versions of games, but not with the latest according to user comments, to be out of scope if said old versions can no longer be easily acquired or played by the general public. I considered using the "OBSOLETE" tag for historical purposes, but since they unfortunately are unplayable, I see no reason to clutter the list with them. Note that as I previously did, I will provide instructions on how to acquire older builds from official sources whenever appropriate.

### Added randomizers

- Civilization V (Civ Randomizer)
- Europa Universalis IV (3 randomizers)
- Hearts of Iron IV
- Imperator: Rome
- Necropolis
- Prey (2017)
- Star Wars Jedi: Fallen Order
- Stardew Valley (Queen of Sauce Randomizer)
- The Elder Scrolls V: Skyrim Special Edition (Alchemy Effects Randomizer + Word Walls Randomizer)
- The Guardian Legend (Micheil Skeens's)
- Victoria II (Random World Generator, both original and newer versions)

### Other changes

- Updated Code Vein randomizer entry with newer version.
- Added instructions on how to downgrade builds for Paradox Development Studio games.
- Tagged The Elder Scrolls V: Skyrim Special Edition Randomized Word Walls as obsolete.
- Removed all randomizers that no longer matches the changes above. (8 in total.)
- Rewrote part of the bottom section to clarify the updated inclusion criteria and restore the honorable mention to the Nintendo 64 version of Resident Evil 2.

## 2020-12-09 #2

- Fixed bad link to the Goof Troop randomizer.
- Minor name fix to the Mega Man 6 and Resident Evil 2 Sourcenext randomizers.

## 2020-12-09

### Added randomizers

- Castlevania: Aria of Sorrow (Randomizer 2)
- Crusader Kings II
- Darkest Dungeon (ddrand)
- Goof Troop
- Metroid Prime 3: Corruption
- Resident Evil 5
- The Legend of Zelda (Infinite Hyrule)
- Willow (NES)

### Other changes

- Removed the Super Mario Bros. 2 Door Randomizer since it is no longer functional. Its author, pepperpow, retired it.
- Updated links and descriptions of the Mega Man 6 and Resident Evil 2 Sourcenext randomizers, as the original links were pointing to deleted Twitter accounts.
- Updated information related to referenced Discord servers.

## 2020-11-16

### Added randomizers

- Octopath Traveler (Boss Randomizer)
- Octopath Traveler (Job Randomizer)
- The Legend of Heroes: Trails of Cold Steel

### Other changes

- Minor correction to Truthkey's Kingdom Hearts II Final Mix randomizer description.

## 2020-10-27

### Added randomizers

- Fire Emblem Awakening (Class-Skill-Randomizer)
- Fire Emblem Awakening (rambon99's)
- The Legend of Zelda (Reloaded)
- Ufouria: The Saga

### Other changes

- Updated link to Fire Emblem: The Sacred Stones Self-Randomizing.

## 2020-10-05

### Added randomizers

- Joe & Mac: Caveman Ninja (Super NES)
- Noita (Steam Workshop - Randomizers)
- Pokémon Gaia Version (Pokémon FireRed Version hack)
- Super Metroid (DASH)
- Super Metroid (Item Randomizer Multiworld)

### Other changes

- Added Universal Pokemon Randomizer ZX support for Pokémon X / Pokémon Y / Pokémon Omega Ruby / Pokémon Alpha Sapphire / Pokémon Sun / Pokémon Moon / Pokémon Ultra Sun / Pokémon Ultra Moon.

## 2020-09-27

### Added randomizers

- Darius Twin
- Rome: Total War
- Shin Megami Tensei III: Nocturne
- Sonic Robo Blast 2 (fangame)
- Super Smash Bros. Melee

## 2020-09-17

Added Medabots: Metabee / Medabots: Rokusho randomizer.

## 2020-09-16

### Added randomizers

- Civilization VI (Tech and Civic Shuffle Mode)
- Darkest Dungeon

### Other changes

- Updated the JSRF: Jet Set Radio Future randomizer link to the latest version. 
- Fixed the Contra randomizer link to a backup, as the official download link has gone dead.
- Fixed the Scourge of War: Gettysburg randomizer links, as NorbSoftDev broke URLs to its forums.

## 2020-09-10

### Added randomizers

- Pokémon Red Version / Pokémon Blue Version / Pokémon Yellow Version: Special Pikachu Edition / Pokémon Gold Version / Pokémon Silver Version / Pokémon Crystal Version / Pokémon Ruby Version / Pokémon Sapphire Version / Pokémon FireRed Version / Pokémon LeafGreen Version / Pokémon Emerald Version / Pokémon Diamond Version / Pokémon Pearl Version / Pokémon Platinum Version / Pokémon HeartGold Version / Pokémon SoulSilver Version / Pokémon Black Version / Pokémon White Version / Pokémon Black Version 2 / Pokémon White Version 2 (Universal Pokemon Randomizer ZX)
- Pokémon Trading Card Game (pokepress's)
- Sonic the Hedgehog (2006)
- Zanac

### Other changes

- Added Crash Bandicoot, Crash Bandicoot 2: Cortex Strikes Back and Crash Bandicoot: Warped to the list of games supported by Crate Mod Loader.
- Marked xCrystal's Pokémon Trading Card Game randomizer as obsolete.

## 2020-09-04

### Added randomizers

- Final Fantasy XIII (Steam)
- Lisa: The Pointless (fangame)
- Tomb Raider II

### Other changes

- Updated link to the Grand Theft Auto: San Andreas randomizer.

## 2020-09-01

Note that I recently lowered the standard for list inclusion so that randomizers don't absolutely have to be designed to prevent unwinnable states, as long as such occurances are extremely unlikely or have reasonable workarounds. If this starts to cause too many problems, I might revert this decision in the future.

### Added randomizers

- Grand Theft Auto: San Andreas
- Hitman 2
- Minecraft: Java Edition (Fasguy's + 2 obsolete ones)
- Need for Speed Carbon
- Ninja Gaiden (NES)
- Paper Mario: The Thousand-Year Door (Infinite Pit)

### Other changes

- Updated link to AM2R fan update (again) and improved description.
- Updated link to the Paper Mario: The Thousand-Year Door Shufflizer.
- Removed link to the Everest mod loader for Celeste, as the randomizer requiring already links to it in its documentation.
- Modified the definition of what a randomizer is based on the lowering of standard described above.

## 2020-08-25

### Added randomizers

- Final Fantasy VIII / Final Fantasy VIII Remastered
- Godzilla: Monster of Monsters
- Monster Party
- Teenage Mutant Ninja Turtles (NES) (abyssonym's)
- Teenage Mutant Ninja Turtles (NES) (kavoc's)

## 2020-08-13

### Added randomizers

- Secret of Evermore
- Timespinner

### Other changes

- Updated URL to the Terranigma randomizer to one that does not require a Discord account.
- Updated URL to the Donkey Kong Country and Donkey Kong Country 2: Diddy's Kong Quest randomizers.

## 2020-08-03

### Added randomizers

- Bloodborne
- Celeste
- Clash at Demonhead
- Code Vein
- Kirby & The Amazing Mirror (HeyImTG's)
- The Elder Scrolls III: Morrowind (Door Randomizer)
- The Legend of Zelda: A Link to the Past (Berserker's Multiworld)

### Other changes

- Updated URL to the The Legend of Zelda: Twilight Princess randomizer.

## 2020-07-24

### Added randomizers

- DuckTales
- OpenTyrian (Tyrian open source port)

### Other changes

- Added cheat code to unlock AM2R Random Game+ mode, which was introduced in fan patch v1.5.
- Clarified that Multi-series is at the bottom of the list where applicable.

## 2020-07-21

### Added randomizers

- ActRaiser
- Kingdom Hearts II Final Mix (Valaxor's)
- Neutopia
- Pokémon Mystery Dungeon: Explorers of Sky (SkyTemple Randomizer)
- The Legend of Zelda: Ocarina of Time / The Legend of Zelda: Ocarina of Time Master (Roman971's)

### Other changes

- Added Yuurand: Tales of the Labyrinth as a randomized Zelda Classic quest.
- Added link to Niamek's The Philosophy of Randomizers document.

## 2020-07-09

### Added randomizers

- Deus Ex
- Kirby & The Amazing Mirror
- Shining Force
- Solstice
- Super Paper Mario
- The Witness (Witness Random Puzzle Generator)

### Other changes

- Added Mirage Island as a randomized Zelda Classic quest.

## 2020-06-18

### Added randomizers

- Fire Emblem: Radiant Dawn
- The Adventures of Captain Comic

### Other changes

- Minor edit of the Super Castlevania IV randomizer link to point directly to the latest version.

## 2020-06-14

### Added randomizers

- Solar Jetman

### Other changes

- Removed the Contra / Super C randomizer. From the author metalmachine: "The last build posted was broken and I don't have the source anymore, so this project is dead for the time being." 
- Updated links to the Pokémon XD/Colosseum randomizer and the Half-Life randomizer.
- Added additional special emulator information and links to them where applicable.
- Added warnings that the Half-Life 2 randomizer and the Game Dev Tycoon TotalRandomiser may not work on the latest version.
- Added note about tabletop game randomizers with a few examples.

## 2020-06-01

### Added randomizers

- Dark Souls III (Fog Gate Randomizer)
- Demon's Souls
- Diablo II
- Fallout 4 (Weapon Quality Randomizer)
- The Legend of Zelda: Link's Awakening DX (LADXR)

### Other changes

- Updated name of Dark Souls III Item Randomiser and Auto-Equip.

## 2020-05-10

### Added randomizers

- Bloodstained: Ritual of the Night
- Mega Man Battle Network 2
- Mega Man Battle Network 5: Team Protoman
- Pathologic 2
- Pikmin

### Other changes

- Split the online and offline randomizers of Pokémon Crystal Speedchoice (hack) as they are diverging.
- Fixed Sekiro: Shadows Die Twice duplicate entry.
- Replaced word "patch" with "update" to avoid confusion.

## 2020-05-06

### Added randomizers

- Azure Dreams (Game Boy Color)
- Crash Nitro Kart / Crash Twinsanity / Crash Tag Team Racing / Rayman 3: Hoodlum Havoc (Crate Mod Loader)
- Crash Tag Team Racing (CTTRRando)
- Dark Souls III (Enemy Randomizer)
- Final Fantasy VII
- Resident Evil 3 (2020)
- Super Win the Game
- The Legend of Zelda: Twilight Princess

### Other changes

- Minor clarification of video game systems acronyms

## 2020-04-11

### Added randomizers

- Dokapon Kingdom

### Other changes

- Added an unofficial web-based port of the Zelda II: The Adventure of Link randomizer.
- Added link to the beta version of the Super Metroid / The Legend of Zelda: A Link to the Past crossover randomizer.
- Updated link to BashPrime's Metroid Prime randomizer.

## 2020-03-20

### Added randomizers

- Sekiro: Shadows Die Twice
- Yu-Gi-Oh! The Duelists of the Roses

### Other changes

- Added offline version of the Pokémon Crystal Speedchoice randomizer.
- Fixed link to online version of the Pokémon Crystal Speedchoice randomizer.
- Updated duncathan salt's Cave Story randomizer entry with Cave Story+ compatibility.
- Marked shru's Cave Story randomizer as obsolete.
- Updated link to BloodSweatAndCode's Castlevania II: Simon's Quest randomizer.
- Fixed Kingdom Hearts II Final Mix game name.

## 2020-03-06

### Added randomizers

- Dark Souls: Prepare to Die Edition / Dark Souls: Remastered (Paramdomizer)
- Dark Souls III (Irregulator)
- Final Fantasy (Deep Dungeon)
- Fire Emblem: Shadow Dragon
- The Simpsons: Hit & Run
- The Ultimate Doom / Doom II / Final Doom / Heretic / Hexen: Beyond Heretic / Strife / Chex Quest (Universal Entropy)
- The Ultimate Doom / Doom II / Final Doom (QuakeStyle Unbound)
- The Ultimate Doom / Doom II (QuakeStyle ZX)

### Other changes

- Added Fire Emblem: Path of Radiance to the list of games supported by Yune.
- Updated links to ducathan salt's Cave Story randomizer, jespoke's Fire Emblem: Path of Radiance randomizer, and the FFX Randomizer.
- Fixed game compatibility for a few Doom II randomizers.

## 2020-02-21

### Added randomizers

- Dark Souls III (Static Item Randomizer)
- Stardew Valley (More Random Edition)
- The Elder Scrolls II: Daggerfall
- The Elder Scrolls III: Morrowind (4NM_Randomizer)

### Other changes

- Updated link to Gato Roboto randomizer to one that doesn't require a Discord account.

## 2020-02-08

### Added randomizers

- Donkey Kong Country 2: Diddy's Kong Quest
- Final Fantasy VI (Worlds Collide)
- Pokémon Crystal Version (Item Randomizer)
- Terraria (JamSnack's)
- You Have to Win the Game

### Other changes

- Removed the Fire Emblem: Shadow Dragon and the Blade of Light randomizer, because the executable has been missing for more than a month, and because I can't find a mirror of it. Unfortunately I have been unable to contact the author about this issue so far. The only clue I have left is that the Dropbox account uploader was "J. Posadas".
- Removed the following entries due to containing pre-applied randomization data: Resident Evil Outbreak, Resident Evil Outbreak File #2, The Legend of Zelda: Ocarina of Time (finap13's Item Randomizer)
- Clarified the exclusion criteria list, including about the previous point.

## 2020-01-11

### Added randomizers

- Gato Roboto
- Pokémon Red Version / Pokémon Blue Version (Ubuntaur's, obsolete)
- Pokémon Gold Version / Pokémon Silver Version / Pokémon Crystal Version / Pokémon Ruby Version / Pokémon Sapphire Version / Pokémon FireRed Version / Pokémon LeafGreen Version / Pokémon Emerald Version (pateandrew's, obsolete)
- Quake (EXQ)
- Quake (RandoQ)

### Other changes

- Added note that the New section does not include obsolete entries.

## 2020-01-02

### Added randomizers

- Pokémon Red Version / Pokémon Blue Version (Key Item Randomizer)

### Other changes

- Fixed broken link to the Resident Evil 2 Sourcenext randomizer.

## 2019-12-26

### Added randomizers

- Chrono Trigger (Jets of Time)
- Hollow Knight (various randomizers)
- Kingdom Hearts II Final Mix

### Other changes

- Added link to the source code of the The Legend of Zelda: Twilight Princess HD randomizer.
- Merged all Hollow Knight randomizers into a single entry.

## 2019-12-07

Added additional information about the Resident Evil Outbreak randomizers and related fan servers.

## 2019-12-06

### Added randomizers

- Citadel
- Resident Evil Outbreak
- Resident Evil Outbreak File #2

## 2019-11-30 #2

Added Fire Emblem: Shadow Dragon and the Blade of Light randomizer.

## 2019-11-30

### Added randomizers

- Dark Souls: Prepare to Die Edition / Dark Souls: Remastered (Fog Gate Randomizer)
- Pokémon Crystal Speedchoice (hack) (Key Item Randomizer)
- Pokémon: Let's Go Pikachu! / Pokémon: Let's Go Eevee! / Pokémon Sword / Pokémon Shield
- Super Smash Bros. Ultimate

### Other changes

- Added unofficial Speedchoice hacks support information for Universal Pokemon Randomizer.
- Added note about where to find Speedchoice hacks for Pokémon games due to their obscurity.
- Clarified that the Dark Souls randomizers are for both Prepare to Die Edition and Remastered.
- Removed the obsolete tag for ORO-RANDOM-DOOM.

## 2019-11-15

### Added randomizers

- Golden Sun: The Lost Age

### Other changes

- Clarified which beta branch is applicable to access the Yoku's Island Express randomizer.
- Relabelling of "built-in" randomizers to "Included".

## 2019-11-10

After a long consideration, I decided to include randomizers that are included in official games under certain conditions. Specifically, such randomizers must not be part of the core experience, nor present in the original release. Note that I might tweak this rule in the future if it turns out to be too restrictive or too lax.

### Added randomizers

- Metroid (Planets)
- Resident Evil 2 (N64) (built-in)
- Yoku's Island Express (built-in)

### Other changes

- Updated randomizer definition and exclusion list to match the above change.
- Removed honorable/dishonorable mentions.

## 2019-10-12

Clarified that the Resident Evil 3: Nemesis randomizer is also a trainer.

## 2019-10-10

### Added randomizers

- Environmental Station Alpha
- Half-Life
- Resident Evil 3: Nemesis

### Other changes

- Removed link to the Dark Souls Weapon Randomizer as it was deleted by the author, Robert Michaels. After verification with him, it was apparently unfinished, and was a sub-function of the item randomizer for the same game anyway.
- Added EmoTracker in the I Want More section.

## 2019-10-05

### Added randomizers

- La-Mulana 2
- Pokémon Stadium 2
- The Ultimate Doom / Doom II / Final Doom (Complex DooM)
- Left 4 Dead 2
- Half-Life 2

## 2019-09-26

### Added randomizers

- Faxanadu
- Heretic (Legions, Style Mod)
- Doom-engine games (CustomDoom, HXRTC Project Golden Edition, Universal Custom Doom, Vanilla Doom Plus)

### Other changes

- Updated link to the Illusion of Gaia randomizer.
- Minor link updates for multiple randomizers hosted on phpBB forums.
- Minor edit in Samsara's description for consistency.

## 2019-09-07

I previously forgot to put the Subnautica randomizer in the main list in addition to the new sub-list. This has been fixed.

## 2019-09-05

### Added randomizers

- Fire Emblem: Three Houses
- Golden Sun
- Subnautica

### Other changes

- Removed note that the Zelda 1 / Metroid 1 crossover randomizer requires a special emulator, as it no longer applies.
- Updated links to the Azure Dreams randomizer and the Metroid Metrandomizer.

## 2019-08-24

Added Fire Emblem: Mystery of the Emblem randomizer.

## 2019-08-13

### Added randomizers

- Lost Kingdoms
- X3: Terran Conflict

### Other changes

- Fixed 2019-04-19 changelog entry where I forgot to mention Civilization V Randomized Uniques.

## 2019-08-08

Updated link of the JSRF: Jet Set Radio Future randomizer to latest version.

## 2019-08-07

### Added randomizers

- Castlevania II: Simon's Quest (BloodSweatAndCode's)
- Chrono Trigger (Wings of Time)
- Pokémon Colosseum / Pokémon XD: Gale of Darkness (Reclaimer Shawn's)
- The Legend of Zelda: The Minish Cap

### Other changes

- Slight clarifications to the exclusion list.

## 2019-07-20

Added Terranigma randomizer.

## 2019-07-14

### Added randomizers

- Project Base (Super Metroid hack)
- Z-Factor (Super Metroid hack)
- Unreal Tournament (Map Randomizer)
- Unreal Tournament (XMaps)

### Other changes

- Added unofficial 64-bit version of OBLIGE.
- Updated names of Super Mario RPG: Legend of the Seven Stars randomizers to latest.
- More compact reformatting of hack and mod references, including the removal of links to Final Fantasy VI Brave New World and Super Mario Land 2 DX.

## 2019-07-13

### Added randomizers

- Hyper Metroid (unofficial Super Metroid hack)
- X2: The Threat (XUniverseWizard)

### Other changes

- Fixed link to X2: The Threat Galaxy Editor, added small clarification about its content, and marked it as obsolete.

## 2019-07-10

### Added randomizers

- Aerobiz Supersonic
- X2: The Threat

Note: While the X2 Galaxy Editor website is down as I'm writing this, it was working last week according to Google's cache, so I'm assuming it is a temporary problem. I'll update the link in the future to backed up copy from the Internet Archive if it appears otherwise in the future.

## 2019-07-02

### Added randomizers

- Dead Rising

### Other changes

- Updated the glitch-related exclusion guideline to be specific to those that trivializes the challenge.
- Restored DeathBasket's The Legend of Zelda: Majora's Mask randomizers with a difficulty warning.

## 2019-06-29

### Added randomizers

- Final Fantasy I & II: Dawn of Souls (HMS Jayne)

### Other changes

- Added glitch-related exclusion guideline, as they are equivalent to softlocks for casual players.
- Removed both of DeathBasket's The Legend of Zelda: Majora's Mask randomizers due to the required use of glitches.
- Removed MrCheeze's Paper Mario randomizer due to softlocks caused by randomization softlocks.
- Split The Elder Scrolls V: Skyrim Special Edition randomizers into separate entries for consistency.
- Clarified the description of Sword Coast Stratagems for Baldur's Gate II.
- Added note that the list is irrelevant of each randomizer's fun factor.

## 2019-06-21

### Added randomizers

- Azure Dreams

### Other changes

- Added link to the Making a Randomizer AGDQ 2019 panel in the I Want More section.

## 2019-06-10

Added Kid Icarus randomizer.

## 2019-06-02

### Added randomizers

- Baldur's Gate / Baldur's Gate II: Shadows of Amn (Item Randomiser)
- Baldur's Gate / Baldur's Gate: Enhanced Edition / Baldur's Gate II: Shadows of Amn / Baldur's Gate II: Enhanced Edition (Sword Coast Stratagems)
- Baldur's Gate II: Shadows of Amn (Improved Anvil)
- Baldur's Gate II: Enhanced Edition (Improved Anvil Enhanced Edition)

### Other changes

- Removed SMB Medley from the list after realizing while watching Vargskelethor's Twitch stream that level transitions are random instead of randomized.
- Fixed typo in The Legend of Zelda: Majora's Mask game name.

## 2019-05-27

### Added randomizers

- Fire Emblem: Thracia 776
- Fire Emblem: Path of Radiance

### Other changes

- Updated Fire Emblem game names to their modern English variants, as they appear in Fire Emblem Heroes and its website.
- Added Fire Emblem: Genealogy of the Holy War as a newly-supported game for Yune.
- Marked jespoke's Fire Emblem: Genealogy of the Holy War randomizer as obsolete.

## 2019-05-26

### Added randomizers

- Illusion of Gaia
- Donkey Kong Country 3: Dixie Kong's Double Trouble
- Pokémon Trading Card Game (Aroymart's)

### Other changes

- Put back references to the DKC Entrance Rando as the author restored the link, and added ROM version requirement as it is not clearly documented for the older DKC Randomizer.
- Added a link to Twitch's Randomizer tag filter page.

## 2019-05-20

### Added randomizers

- Sonic Adventure DX
- Sonic Mania

### Other changes

- Minor change to the Resident Evil 2 Sourcenext version name.
- Simplified a few location-related descriptions.

## 2019-05-17

### Added randomizers

- Resident Evil 2 (2006 Sourcenext)
- Sonic Adventure 2
- Super Mario 64 (aGlitch's)
- Super Mario 64 (Andre Meyer's)

### Other changes

- Reverted the Donkey Kong Country entry since the author removed the link to the DKC Entrance Rando for fixes.
- Minor randomizer names change to some of the Borderlands, Earthbound and The Legend of Zelda: Ocarina of Time randomizers for consistency.
- Rewrote the introduction of the "What is this list" section.
- Added "Randomization that is not persistent within the same playthrough" as an insufficient criterion.

## 2019-05-10

### Added randomizers

- JSRF: Jet Set Radio Future
- The Legend of Zelda: Majora's Mask (ZoeyZolotova's)

### Other changes

- Updated the Donkey Kong Country entry since the linked page now contains two separate randomizers for this game.
- Marked DeathBasket's 2019 The Legend of Zelda: Majora's Mask randomizer as obsolete.
- Minor randomizer name changes for the Mario RPGs.

## 2019-05-05

### Added randomizers

- Metroid Prime 2: Echoes (Randovania)

### Other changes

- The old entry for Claris's Metroid Prime/Echoes Randomizer has been replaced with an entry for the obsolete Metroid Prime Seed Generator instead for consistency and clarity. Note that the reference to the Metroid Prime 2: Echoes winnable seed generator has been removed because it became Randovania, which is currently the official host of a newer version of Claris's Randomizer. Also note that the reference to the optional Metroid Prime Randomizer Script has also been removed to prevent confusion and messiness.
- Minor change to the names of Deathbasket's The Legend of Zelda: Majora's Mask randomizers.

## 2019-05-04 #2

- Updated link to Wild Mouse's Castlevania: Symphony of the Night randomizer.
- Minor fixes to game names and platforms in the Dragon Quest franchise.
- Another minor grammatical fix.

## 2019-05-04

### Added randomizers

- Final Fantasy X/X-2 HD Remaster (FFX Randomizer)
- Lizard
- Metal Gear

### Other changes

- Updated Super Mario Land 2: 6 Golden Coins randomizer URL.
- Minor grammatical fix.

## 2019-04-19

### Added randomizers

- Civilization V (Randomized Uniques)
- Civilization V (various map scripts)
- Civilization VI (various map scripts)

### Other changes

- Simplified URL to the Crystalis randomizer.

## 2019-04-15

### Added randomizers

- Blaster Master
- Castlevania: Symphony of the Night (Wild Mouse's)
- Final Fantasy V (Career Day)

### Other changes

- Removed all randomizers in the Team Fortress series (including the fangame) for violating the chaotic effects rule.
- Tagged old Castlevania: Symphony of the Night relic randomizer as obsolete.

## 2019-04-05

### Added randomizers

- Civilization IV (massive collection of map scripts from CivFanatics and GameFront)
- Civilization IV: Colonization
- C-evo (Civilization II fangame)
- Dwarf Fortress
- Resident Evil 2 (2019)
- Super Mario Bros. 2 (Door Randomizer)
- Super Mario 64 (a non-chaos one this time)

### Other changes

- Added ObAddon unofficial expansion to OBLIGE.
- Updated links to the Mega Man Battle Network 5/6, Ori and the Blind Forest and Sonic the Hedgehog (SMS) randomizers.
- Fixed links to randomizers originally hosted on Yahoo! GeoCities Japan since it shut down.
- Fixed randomizers hosted on Nexus Mods and archived from GameFront back to GameFront now that it's back online.
- Forgot to set the link to Final Fantasy Legend III randomizer to use HTTPS instead of HTTP.
- Minor simplification of URLs for the Final Fantasy III randomizer and starmen.net links.
- Replaced OUTDATED tags with OBSOLETE tags to avoid confusion related to their release date.
- Added clarification about not documenting required expansions and DLC from game name rules.

## 2019-03-23

### Added randomizers

- Cave Story (duncathan salt's)

### Other changes

- Updated link to the Super Metroid / A Link to the Past crossover randomizer.
- Removed beta link for the Super Mario RPG randomizer as it's now on the main website.
- Added dishonorable mention for Action 52 Genesis.

## 2019-03-11

Added Silent Hill 2 / Silent Hill 3 randomizer.

## 2019-03-09

### Added randomizers

- Donkey Kong 64
- Shin Megami Tensei: Strange Journey
- The Witness

### Other changes

- Minor description changes to Claris's Metroid Prime 1 and 2 randomizer.

## 2019-03-03

### Added randomizers

- Pokémon: Let's Go Pikachu! / Pokémon: Let's Go Eevee!

### Other changes

- Removed redundant NES tag for the original version of Final Fantasy.

## 2019-02-24

- Split and updated The Legend of Zelda: Ocarina of Time / Master Quest item randomizer into two entries, now that v4.0 is maintained separately from v3.0 and that the web patcher is now official with the new version. v3.0 is also now marked as OUTDATED.
- Fixed entries for Sanqui's randomizers, including removing the OUTDATED tag for his Pokémon Red Version randomizer since it runs online.

## 2019-02-19

Added Axiom Verge randomizer.

## 2019-02-16

- Updated BrutalOblige URL.
- Fixed Super Meat Boy series's name.
- Fixed Hexen: Beyond Heretic game name in Samsara description.

## 2019-02-15

### Added randomizers

- Doom II (Colourful Hell)
- Super Adventure Island II
- Tecmo Super Bowl
- The Legend of Zelda: Majora's Mask (DeathBasket's, 2019 edition)

### Other changes

- Now showing multi-series game list reference at the end of each series instead of mixed in-between non-multi-series entries.
- Added series for games only listed in Multi-series.
- Updated URL for the ModOhFun! randomizer for Doom II.
- Fixed game list and series for Doom engine entries, including only listing Doom II when original documentation was unclear.
- Fixed Crystalis not being in alphabetical order.

## 2019-02-09

### Added randomizers

- Crystalis
- Final Fantasy Legend III (under SaGa)

### Other changes

- Moved the OUTDATED tags to the end of each entry instead of the beginning.
- Fixed minor typo in Super Metroid Item Randomizer entry.

## 2019-02-06

### Added randomizers

- Final Fantasy Tactics Advance

### Other changes

- Renamed the X-COM series to its modern name XCOM.
- Renamed the Soul Blazer series to Illusion of Gaia, as it is the most modern name of the series that was officially disclosed. For those unaware, there is a direct story connection between Soul Blazer and Illusion of Gaia, and Terranigma is referred in-game as "Illusion of Gaia 2".
- Removed series' alternate names. Maybe I'll put some of them back in the future if I ever define a clear criteria for doing so that I'm satisfied with.

## 2019-02-03

### Added randomizers

- Dark Souls III (StraySouls)

### Other changes

- Replaced the "New and updated games" section with a "New randomizers" section, with direct links to the randomizers.
- Removed the NEW and UPDATED tags in the main list as they are now redundant.
- Minor layout changes.

## 2019-02-01

Added Wario Land 3 randomizer.

## 2019-01-17

### Added randomizers

- Final Fantasy VI (Beyond Chaos EX)

### Other changes

- Merged the Deprecated section into the main list with new Outdated tags.
- Tagged Beyond Chaos as obsolete.
- Split unofficial forks into their own entries.
- Modified a few Updated tags to New tags for clarity.
- Added source code link to all of Sanqui's randomizer entries.

## 2019-01-12

Fixed entry for the Nestroid Randomizer for Metroid.

## 2019-01-11

- Modified descriptions to refer to randomizers' name or primary author instead of features.
- Added source code to Sanqui's Pokémon Trading Card Game.
- Removed the online helper to Seanpr's Hollow Knight randomizer.

## 2019-01-10

- Removed the Other category and split each entry from it into independent categories.
- Added beta version of the Super Mario RPG: Legend of the Seven Stars randomizer.
- Added instructions for the Super Metroid Door Randomizer and Mega Man 2 Endless.
- Updated the link to Snarboo's Doom Monster Randomizer.
- Regrouped some of the Doom-family mods.

## 2018-12-28

### Added randomizers

- Cave Story / Cave Story+
- Super Mario Bros. 3 (online version)

### Other changes

- Updated link to the Ori and the Blind Forest randomizer and removed its optional GUI link as it's no longer up-to-date.

## 2018-12-26

Merged Pokémon Colosseum and Pokémon XD: Gale of Darkness entries to a new link that combines both.

## 2018-12-23

### Added randomizers

- Dragon Quest Monsters 2: Cobi's Journey / Dragon Quest Monsters 2: Tara's Adventure (x2)

## 2018-12-14

Updated link to the Fire Emblem: The Sacred Stones self-randomizer to one that supports HTTPS.

## 2018-12-10

### Added randomizers

- Ultima IV: Quest of the Avatar (NES)
- The Goonies II (new web-based version)

### Other changes

- Moved the older The Goonies II randomizer to the Deprecated section.
- Updated game name for Phantasy Star IV: The End of the Millennium.
- Updated URL to Final Fantasy IV's The Lunarian Shuffle randomizer.
- Updated the descriptions of The Legend of Zelda randomizers to take into account recent updates.
- Added missing "unofficial mod" mention to Samsara within the Deprecated section. 

## 2018-12-02

### Added randomizers

- Final Fantasy V Advance (extensive changes)
- Final Fantasy V Advance (roguelike)

### Other changes

- Fixed the description of the Fallout: New Vegas randomizer.
- Updated description of wormsofcan's Final Fantasy V Advance job abilities randomizer.
- Updated the Mega Man 6 randomizer entry to a single link to the original announcement tweet.
- Updated link and description of the Donkey Kong Country randomizer so it always points to the latest version.
- Updated AM2R's community patch link to one that should always point to the latest version.
- Clarified location of randomizers hosted on YouTube and Twitch links.

## 2018-12-01

### Added randomizers

- Stardew Valley

### Other changes

- Updated AM2R's community patch link to the latest version.
- Fixed missing "NEW" tag for the Final Fantasy XII The Zodiac Age randomizer.

## 2018-11-27

### Updated randomizers

- The Legend of Zelda: Oracle of Ages / The Legend of Zelda: Oracle of Seasons

### Other changes

- Added link to The Legend of Zelda: Ocarina of Time randomizer web patcher.
- Added Super Mario Land 2 DX (unofficial hack) compatibility for the Super Mario Land 2: 6 Golden Coins randomizer.
- Removed finap13's Paper Mario randomizer due to violating the chaotic effects rule.
- Rewrote warning with old Metroid Prime / Metroid Prime 2: Echoes randomizer.
- Other minor description changes.

## 2018-11-07

- Correction: The new Final Fantasy XII randomizer is for The Zodiac Age version, not the original version.
- Added style rules to list of game name criteria.

## 2018-11-04

### Added randomizers

- Dark Souls (enemies)
- Final Fantasy XII

### Updated randomizers

- Dark Souls II (items)
- Fire Emblem: The Binding Blade / Fire Emblem / Fire Emblem: The Sacred Stones
- The Legend of Zelda: Ocarina of Time / The Legend of Zelda: Ocarina of Time Master Quest

### Other changes

- Moved the original versions of Jgwman's Dark Souls II randomizer and lushen124's Fire Emblem randomizers to the Deprecated section.
- Simplified the description for The Legend of Zelda: Ocarina of Time item randomizer beta fork.
- Fixed abyssonym's EarthBound randomizer incorrectly being in the Other section instead of the Deprecated section.
- Removed the item tracker link for the La-Mulana remake randomizer.
- Minor fixes to Nexus Mods URLs.
- Updated the insufficient for inclusion list and game name criteria.
- Removed new/updated tags that were accidentally left to the multi-game category redirects.

## 2018-10-20

### Added randomizers

- Digimon World

### Other changes

- Updated links to Paper Mario: The Thousand-Year Door Shufflizer and The Legend of Zelda: Majora's Mask Beta Quest

## 2018-10-04

- Removed the Enemizer extension for The Legend of Zelda: A Link to the Past item randomizer as it has been integrated in it, and updated its description accordingly.
- Updated link to tetraly's The Legend of Zelda randomizer.
- Minor update in the descriptions of both The Legend of Zelda randomizers.

## 2018-09-28

### Added randomizers

- La-Mulana (original freeware version)

### Other changes

- Clarified that the other La-Mulana randomizer is for the 2011 remake.
- Removed description of the Secret of Mana randomizer, at least for now, to avoid confusion.

## 2018-09-16

Clarified that the Majora's Mask loading zones randomizer requires a cheat engine.

## 2018-09-10

### Added randomizers

- Sonic the Hedgehog (Sega Master System)
- The Legend of Zelda (full item randomization)
- The Legend of Zelda: Majora's Mask (loading zones)

### Other changes

- Updated Fred Coughlin's The Legend of Zelda randomizer description.

## 2018-09-02

- Added a Metroid Prime 2: Echoes winnable seed generator for Claris's randomizer, and moved the later out of the deprecated section with warnings.
- Updated link to the Super Mario Bros. 2 randomizer for one that doesn't require a Discord account.
- Minor clarification of usage instructions for AM2R's randomizer.

## 2018-09-01

### Added randomizers

- Metroid II: Return of Samus
- Wario Land 4

### Other changes

- Updated AM2R's community patch to latest version and related instructions.
- New website, same URL.

## 2018-08-25 #2

Reverted changes from earlier today related to The Legend of Zelda: Majora's Mask. Turns out that I goofed and did not realize that the new version by Alex Trush is still a work-in-progress and not playable yet. Oops.

## 2018-08-25

### Added randomizers

- The Legend of Zelda: Majora's Mask (new version with advanced logic)

### Other changes

- Added a beta fork to the The Legend of Zelda: Ocarina of Time item randomizer
- Moved DeathBasket's randomizer for The Legend of Zelda: Majora's Mask in the deprecated section as it has less features compared to the new one.
- Updated link of the Final Fantasy IV open world randomizer to its new domain name.

## 2018-08-22

### Added randomizers

- Rockman 3: Winternight (unofficial hack)

### Other changes

- Updated link to the Metroid / The Legend of Zelda crossover randomizer.
- Rewrote a good chunck of the informational section at the bottom of the page.

## 2018-08-06

Updated links of the new Super Mario RPG: Legend of the Seven Stars randomizer and The Legend of Zelda: A Link to the Past item randomizer to HTTPS.

## 2018-08-05

### Added randomizers

- Super Mario RPG: Legend of the Seven Stars
- EarthBound (deprecated)

### Other changes

- Corrected Dark Souls series name.
- Deprecated the old Super Mario RPG randomizer.
- Updated links to the Final Fantasy IV Roguelikeifyer and the Lufia II: Rise of the Sinstrals randomizer.

## 2018-08-02

### Added randomizers

- The Legend of Zelda: Oracle of Seasons
- Borderlands: The Pre-Sequel (deprecated)

### Other changes

- Fixed Pokémon game names in deprecated list.

## 2018-07-30

### Added randomizers

- Borderlands: The Pre-Sequel
- Contra (NES)

### Other changes

- Added info about crossover randomizers that requires a special emulator to run.
- Minor update to the Final Fantasy X randomizer's description.
- More general improvements and fixes related to new/updated information.
- Updated more links from HTTP to HTTPS.

## 2018-07-23

### Added randomizers

- Mega Man 4 (enemies, items)

### Other changes

- Appended alternate name "Rockman" to the "Mega Man" category name.
- Improved download instructions for the Mega Man roguelikes.

## 2018-07-22 #2

- Fixed Final Fantasy NES randomizer link.
- Fixed game name for all main Pokémon games up to Black and White.
- General improvements and fixes in "New or updated" section.
- Added missing NEW and UPDATED tags.

## 2018-07-22

- Added Pokémon Ultra Sun and Pokémon Ultra Moon to the list of supported games with the existing Nintendo 3DS Pokémon randomizer.
- Fixed game name for Pokémon Black Version 2 and Pokémon White Version 2.
- Added "New and updated" section at the top of the page.
- Added NEW and UPDATED tags.

## 2018-07-07

### Added randomizers

- The Legend of Zelda: The Wind Waker (items, open world)

### Other changes

- Replaced "entrances" tags to "loading zones" for consistency.
- Updated tags for the Final Fantasy IV open world randomizer.

## 2018-06-30

Updated link to the The Legend of Zelda: A Link to the Past items/entrances randomizer.

## 2018-06-29

### Added randomizers

- Super Metroid (items, with extensive customization options)

### Other changes

- Deprecated old Super Metroid items randomizers.
- Clarified that the Contra / Super C crossover randomizer is for the NES port of Contra, not the original arcade version.
- Standardized romanized names in international Kunrei-shiki except for katakana.
- Added note about which game names are used in the list.

## 2018-06-25

Updated the Mega Man Battle Network 3 randomizer with a new version that also supports Blue Version, and put the original randomizer as deprecated.

## 2018-06-23

### Added randomizers

- The Legend of Zelda: The Wind Waker (entrances)

### Other changes

- Updated link and instructions for the Castlevania: Symphony of the Night randomizer.
- Updated Fire Emblem: Seisen no Keifu's game name to standardize Japanese-only titles and avoid unofficial translations.
- Added Probotector alternate name in Contra's category name for European readers.

## 2018-06-21

### Added randomizers

- Metroid Prime

### Other changes

- Moved Chris's old Metroid Prime randomizer as deprecated, and modified its description to address winnability issues, including a warning to not use it for Metroid Prime 2: Echoes.
- Updated links to the Contra / Super C and the Metroid / The Legend of Zelda crossover randomizers.

## 2018-06-17

### Added randomizers

- Metroid / The Legend of Zelda (crossover)

### Other changes

- Updated link and description for the Contra / Super C crossover randomzier.

## 2018-06-16

### Added randomizers

- Contra / Super C (crossover)
- Rad Racer

## 2018-06-08

- Renamed list from "The BIG List of Randomizers" to "The BIG List of Video Game Randomizers".
- Added the "Doom", "Heretic", "Team Fortress" and special "Multi-series" categories.
- Removed company-specific categories as it made specific games harder to find.
- Replaced "See also" to "See Multi-series category" and identified individual games accordingly
- Updated links and descriptions for EarthBound, Legacy of the Wizard and Phantasy Star IV randomizers.
- Updated a bunch of links to HTTPS.
- Removed America's Army automatic weapon swap randomizer.

## 2018-06-01

### Added randomizers

- Phantasy Star II
- Team Fortress II (closed source service)
- Wolfenstein 3D (from an old version of the Doom level generator already on the list)

### Other changes

- Updated link of the Phantasy Star IV randomizer to the latest version.
- Updated list of supported games for the Doom level generator.
- Fixed The Ultimate Doom game name.
- Further clarified exclusion list.

## 2018-05-22

About the "Corruptors", "Restrictions" and "Bingo" stuff, I have come to the following conclusions:

- Restriction generators are nice tools for convenience and inspiration, but are in general unnecessary as they can be easily replicated by generating a few random numbers at specific key points in the relevant game and associating each number with a choice the player has to comply with. The big exception is for speedrun races where the random conditions should be hidden until the race start, but I believe that such tools are better shared within the relevant speedrunning communities instead.
- Bingos are the most complex restriction generators due to their 5x5 grid format and balancing issues, so the easy replication argument does not apply for them. However, they are exclusively designed for speedrunning purposes, and I've had multiple speedrunners tell me that bingos don't actually feel random, so again I believe that such tools are better shared within the relevant speedrunning communities instead.
- Corruptions usually fall into my self-imposed exclusion of "only adding random elements over the normal game". The reason I made this exclusion in the first place is because they are generally trivial to make and usually has extremely limited replay value. Corruptors that don't have those issues unfortunately have the side-effect of causing softlocks and crashes, both of which are undesireable states within randomizer communities.

For these reasons, I no longer feel that awareness of these tools justifies their inclusion on a randomizer list. Therefore, I have decided to remove these categories and their content altogether. As a side-effect, this will also allow me to dedicate more time to the main list. [Here is a backup in case others want to pick them up and continue from where I left off](https://pastebin.com/HE4THZLM). I will consider linking to such successor lists if they become a reality.

### Added randomizers

- Fire Emblem: Genealogy of the Holy War
- Fire Emblem Fates
- Soul Blazer
- Super Metroid + The Legend of Zelda: A Link to the Past (crossover... as in both games are merged together before randomization - a technical achevement and the first of its kind!)

### Other changes

- Removed all corruptors, restrictions and bingos. (See above for the detailed explanation.)
- Removed automatic weapon swap randomizers from the Souls category.
- Added the Capcom, Konami, Microsoft, Nintendo, Sega, Square Enix categories.
- Merged the Rare category with the new Nintendo category, the Shining category with the new Sega category, and the Mana category with the new Square Enix category.
- Cleaned up remaining category names.
- Added "See also" for randomizers that matches multiple categories.
- Updated link for the Mega Man 3/4/5 roguelikes to rock5easily's new website and added download instructions for people that can't read Japanese.
- Moved back general information to the bottom of the list and updated it.
- Added the "I want more!" section.

## 2018-05-05

### Added randomizers

- EarthBound (gift boxes, key items, optional roguelike)

### Other changes

- Updated the style of the list to make it more compact.
- Minor tweak to the description of Final Fantasy IV Beyond Chaos Gaiden randomizer for standardization of hack names.

## 2018-05-04

### Added randomizers

- The Legend of Zelda - Ocarina of Time (items - new one and much more advanced than the old one)

### Other changes

- Moved finap13's old The Legend of Zelda: Ocarina of Time item randomizer in the Deprecated section.
- Moved general information and the tetrimino image to a dedicated blog post.
- Marked special randomizers as bonus lists.

## 2018-04-07

Added AM2R (fangame) randomizer.

## 2018-04-05 #2

Added Fire Emblem section with a new self-randomizing Fire Emblem: The Sacred Stones hack.

## 2018-04-05

Added instructions on where to find the Final Fantasy VI (extensive conservative changes for competitive play) randomizer executable from CodePlex's archive.

## 2018-04-03

### Added randomizers

- Excitebike
- Final Fantasy VI / Brave New World (extensive changes with configurable severity, optional roguelike)
- The Legend of Zelda - Ocarina of Time (restriction section)

### Other changes

- Changed description for the "Roguelikeifyer" and "Beyond Babil" Final Fantasy IV randomizers to "linear roguelike" and "non-linear roguelike" respectively.
- Grouped all restriction randomizers from voidfox.com to a single entry since they share the same URL.

## 2018-03-18

### Added randomizers

- Metroid (map)
- Hollow Knight (enemies)
- Rabi-Ribi (passive bingo)

### Other changes

- Split the list so that special randomizers are not mixed with standard ones.
- Changed the style for better readability on smaller windows.
- Removed the helpful resources link for the A Link to the Past item randomizer as it's now included on its website.
- Removed the Triforce Hunt sprite randomizer link for the A Link to the Past item randomizer as it violated the "cosmetic-only" rule for inclusion.

## 2018-03-04

### Added randomizers

- Resident Evil HD Remaster

## 2018-02-25 #2

### Added randomizers

- Kirby: Nightmare in Dream Land
- Super Mario Bros. 2

### Other changes

- Multiple games for the same randomizer are now separated by slashes instead of ampersands.
- Further standardized game names.
- Updated link to the non-passive Super Mario World randomizer to use HTTPS.
- Fixed Hollow Knight non-special randomizer broken on multiple lines.
- Added missing descriptions to randomizers where an additional randomizer for the same game was also present.
- Added note that the list excludes randomizers already within original games and ports unless an external tool exists.

## 2018-02-25

Added note that the Paper Mario: The Thousand-Year Door item shuffler now also randomizes enemy loadouts in the Pit of 100 Trials.

## 2018-02-18

### Added randomizers

- Golf (NES)
- Kirby Super Star

### Other changes

- Fixed link to The Simpsons: Hit & Run bingo
- Moved both Kirby games in a new Kirby section
- Updated link to Symphony of the Night's relic randomizer to the new official GitHub repository instead of Pastebin.com
- Created full changelog page on my blog

## 2018-02-03

### Added randomizers

- Final Fantasy IV (randomized open world)

### Other changes

- Added missing description for one of the Final Fantasy V randomizers to avoid confusion
- More stuff for the popular The Legend of Zelda: A Link to the Past randomizer: new Triforce Piece Hunt sprite customer and updated helpful resources link
- Renamed "Telefang Power" to the its full name "Keitai Denjuu Telefang: Power Version"
- Reordered games, including new categories: "Rare (company)" (the Donkey Kong games are now in it), "Rockstar Games (company)" and "Star Wars"
- Updated link to the Castlevania: Symphony of the Night randomizer to the latest version

## 2018-01-22

### Added randomizers

- Blade of Darkness (multiplayer weapons)
- Gang Garrison 2 (fangame)
- Grand Theft Auto: Vice City (corruptor)
- Gratuitous Space Battles
- Homeworld 2
- Scourge of War: Gettysburg
- Star Wars: Republic Commando (corruptor)

## 2018-01-21

Alright, well even the abridged list is now too long to fit in a single ROMHacking.net post despite its minimalist design (last iteration was 14746 characters out of 15000). I might be able to tweak it, but I'm going to have the same problem in an iteration or two anyway. Besides, it was starting to be a pain to continuously update 2 similar lists but with with some elements missing between them, and written in different markup languages (BBCodes vs Markdown).

For these reasons, I decided to remove the abridged list from ROMHacking.net. From now on, the BIG list of randomizers will be available exclusively on my blog.

This was not an easy choice, but I believe it is the best thing to do for its continued development. I never expected my list to grow to its current scale nor become a common reference, and it's all thanks to you! I will continue to follow the original ROMHacking.net thread and post updates of any changes there, just like before.

Note that I'll keep the old list in strikethrough on the original post for a while during the transition period just in case.

### Added randomizers

- Dark Souls III (items)
- Final Fantasy V (passive - forgot to add the unofficial Four Job Fiesta to the list because the official one only runs a few days a year (which makes me sad))
- Game Dev Tycoon (appears broken with the latest version but wanted to list it anyway in case it gets fixed eventually)
- Hollow Knight (abilities & charms)
- The Elder Scrolls V: Skyrim (x3: alternate start, Words of Power shuffling, and a deprecated one that generates random dungeons)
- The Talos Principle
- XCOM: Enemy Unknown

### Other changes

- Added additional restrictions on was acceptable or not on the main list.
- Removed the "Unfinished" tag to the Symphony of the Night relic randomizer because I was incorrectly assuming text uploaded to Pastebin couldn't be updated.
- Answered the following fundamental question: "How the fuck do you randomize Tetris?" (actual quote from Twitch streamer Vinesauce)
- Added DELUXE variant of the multi-game bingo


## 2017-12-31

### Added randomizers

- America's Army (times 2!)
- Dark Souls II (items)
- Fallout: New Vegas
- Fallout 4 (tines 2!)
- Metroid: Zero Mission
- State of Decay
- Super Metroid (roguelike)
- Tetris (NES)
- The Elder Scrolls III: Morrowind
- The Legend of Zelda: Link's Awakening DX

### Other changes

- Added La-Mulana randomizer item tracker
- Updated Skyrim randomizer URL
- Standardized game name series prefix

## 2017-11-19

### Added randomizers

- Castlevania II: Simon's Quest
- Doom II (silly enemies and weapons)

### Other major changes

- Added roguelike tag to an existing Paper Mario: The Thousand-Year Door randomizer following new feature.
- Fixed Super Metroid randomizers incorrectly marked as deprecated and added them back on the abridged list.
- Clarified that the A Link to the Past enemies randomizer is an add-on to the items randomizer.
- Replaced Endless Mode tag to roguelike for people not familiar with Mega Man 9/10 DLC.
- Updated link to Final Fantasy (NES) and Kirby's Adventure randomizers.

## 2017-10-24

### Added randomizers

- Paper Mario (a new one for items and loading zones)
- Castlevania: Symphony of the Night (relics)

Note: As of this writing, the Symphony of the Night one is still unfinished.

## 2017-10-15

### Added randomizers

- Divinity: Original Sin 2
- Donkey Kong Country
- Final Fantasy I & II: Dawn of Souls
- Pokémon XD: Gale of Darkness
- System Shock 2

### Other changes

- Updated Super Metroid route randomizer link to its new official page
- Fixed Rabi-Ribi randomizer link on abridged list
- Randomizers appearing in abridged list are now in bold in full list
- Added terminology section in full list
- Removed generic file corruptors from full list

## 2017-09-25

Added a bunch of randomizers for Paper Mario: The Thousand-Year Door, big thanks to Zephiles for sharing them!

The list is now too long to fit on the original ROMHacking.net post!! I kept only the non-passive & non-deprecated randomizers on it. The full list is now on my blog.

Added bingo boards (blog only).

Added non-game-specific corruptors (blog only).

## 2017-09-22

### Added randomizers

- Borderlands 2 (mod bundle which includes various randomizers)
- Final Fantasy VI (exits)
- Lufia II: Rise of the Sinistrals
- Rabi-Ribi
- Super Metroid (items - newer and better than the old one!)
- Star Fox
- The 7th Saga
- The Legend of Zelda: The Wind Waker (corruptor)

### Other changes

- Updated link of the Dark Souls item randomizer to always point to the latest version
- Removed the A Link to the Past entrance randomizer variant as it has been merged with the main items randomizer
- shadowevil1996's Borderlands 2 randomizer is not deprecated
- Dessyreqt's Super Metroid randomizer is now deprecated
- Removed the Super Metroid item randomizer HUD from the list as it was designed for Dessyreqt's version

## 2017-08-18

Fixed typo.

## 2017-07-29

### Added randomizers

- Final Fantasy IV (not a roguelike this time)
- GoldenEye 007
- La-Mulana

## 2017-06-30

Added an entrance variant to the popular A Link To The Past item randomizer.

Minor labeling changes to remove some confusion.

## 2017-06-28

### Added randomizers

- Castlevania: Dawn of Sorrow
- Castlevania: Portrait of Ruin
- Castlevania: Order of Ecclesia

## 2017-06-24

### Randomizers added to the list

- Dark Souls (times 3!!)
- Dark Souls II
- Dark Souls III
- Dragon Quest 1·2 (SNES)
- Duke Nukem 3D
- Final Fantasy V Advance
- Kirby's Adventure
- Legacy of the Wizard
- Mega Man 6
- Ori and the Blind Forest: Definitive Edition
- Phantasy Star IV
- Super Mario Bros. (area shuffling)
- Super Mario Land 2: 6 Golden Coins
- The Legend of Zelda: A Link to the Past (enemies)
- The Legend of Zelda: Twilight Princess HD

### Other changes

- Added link to A Link to the Past item randomizer resources
- Added OBLIGE add-on for Brutal Doom
- Fixed dead links to Ocarina of Time and Majora's Mask randomizers that were originally posted on forums.zeldaspeedruns.com

## 2017-03-31

I've added a second Final Fantasy IV roguelike by abyssonym it to the list, and I'll keep the old one there too until I can figure out if it needs to be moved to the deprecated section or not.

I've also added a new Castlevania: Aria of Sorrow item randomizer, also by abyssonym!

By the way, there are two The Legend of Zelda: A Link to the Past randomizers floating around now. I've added the new one by Veetorp to the main list, and moved the old one by Dessyreqt to the deprecated section, because the latter has been seemingly abandoned and has been used as a base for the new one. It has many new features and bugfixes, so I highly recommend you check it out!

I also found a convenient HUD for that last randomizer that I've added alongside it that should be convenient for Twitch streamers. There's also a version for the Super Metroid item randomizer that I've also added.

## 2017-02-04

### Added randomizers:

- Metroid
- The Elder Scrolls V: Skyrim (roguelike)
- The Goonies II

I actually found two recent Metroid randomizers made within a month of each other.  I'm putting snarfblam's in the main list and Netsrotti's in the deprecated list, as it seems the only advantage of the latter over the former is an option to have duplicate upgrades.

Also, to complement the Hitman passive randomizers, I also found a bunch of nice passive randomizers hosted by Trysdyn (including a Four Job Fiesta generator available all year long) for the following games:

- Diablo II
- Final Fantasy
- Final Fantasy III
- Final Fantasy V
- Final Fantasy VI
- Legend of Mana
- Romancing SaGa 2
- Shining Soul II
- Tales of Destiny
- Zelda II: The Adventure of Link

## 2017-01-26

After investigation, I updated the the link for the Final Fantasy V Ancient Cave to point to ROMHacking.net instead of an archive.org snapshot for convenience.

I also updated the link to the Gensokyo no Nazo randomizer - it now has a proper webpage and many new features!

### Added randomizers

- Amnesia: The Dark Descent (corruptor)
- Pokémon X & Y & Omega Ruby & Alpha Sapphire & Sun & Moon
- Zelda Classic (fangame) (randomizer quests)

Yes, this means that all main international Pokémon games released so far has randomizers. Pretty cool!

And with that, the list now contains more than 100 unique games, and that's only counting official games! I never expected there would be so many when I started. Wow!

## 2017-01-23

Updated the link to the Final Fantasy randomizer following the 1.0 release.

I also added a playable work-in-progress Final Fantasy IV roguelike randomizer.

## 2017-01-11

Added a Pokémon Crystal randomizer that randomly fuses Pokémon with matching evolution stage.

## 2017-01-10

Added two Hitman randomizers to the list. Although they do not actually alter the games, they generate a random set of additional requirements for each mission. I decided to include them despite the lack of in-game enforcement because they still affect gameplay.

## 2017-01-03

The Guardian Legends randomizer is no longer behind a registration wall! The author kindly uploaded the latest version on RHDN after I asked him for a public link. The list has been updated accordingly.

## 2017-01-01

Added Pokémon TCG card randomizer to the list!

## 2016-12-26

Added a Secret of Mana randomizer to the list!

Also added the Doom weapons mod that I had completely forgotten to include back when I added all the Doom mods.

## 2016-11-20

I was let known of a Paper Mario randomizer, but I've seen a few reports that it's not working. I tentatively added it to the list with a note.

## 2016-11-13

Added Yu-Gi-Oh! Forbidden Memories to the list!

## 2016-11-06

### New randomizers added

- Super Meat Boy
- Super Metroid (deprecated)

## 2016-10-30

### Merged missing entries from Kaltenborn's list

- Pokémon Colosseum
- Super Mario Bros.

Also, I realized that the Metroid Prime 2: Echoes randomizer was merged with the Metroid Prime randomizer, so I merged the entries as well.

## 2016-10-23

Added a new Super Mario Bros. 3 randomizer, and moved the old one as deprecated.

## 2016-10-20

Clarified supported versions for the Mega Man Battle Network games, and renamed the Dragon Quest and Fire Emblem games to their official modern titles.

## 2016-10-19

### More awesome randomizers

- Borderlands 2
- EarthBound Beginnings
- Pokémon Mystery Dungeon: Explorers of Sky

### More corruptor randomizers

- Super Mario 64
- The Legend of Zelda: Ocarina of Time

### More depredated randomizers

- EarthBound

## 2016-10-06

Added Mother 3.

## 2016-10-02 #2

Added Reelism mod for Doom II.

## 2016-10-02

First, I added a brand new id Software section, which includes a bunch of new randomizers in it (including a No Man's Sky parody) and updated information about OBLIGE. The games are:

- Ultimate Doom
- Doom II
- Final Doom
- Samsara (unofficial Doom mod)
- Heretic
- Hexen
- Quake
- Quake II

Second, I also added a new randomizer for Gensokyo no Nazo.

And finally, I added a Deprecated section with old Doom, Fire Emblem and Pokémon randomizers that weren't on the list before. I also moved Catastrophe's Dragon Quest and Sanqui's Pokémon Red randomizers in that section, since I believe almost all of their features are included in the other ones.

## 2016-09-27

### Added

- Ocarina of Time (another one)
- Pokémon Stadium
- Super Mario Bros. 3
- Terraria

## 2016-09-24

### Added

- Sven Co-op (corruptor)
- Half-Life 2 (corruptor)
- Team Fortress 2
- Yoshi's Island (corruptor)

## 2016-09-22

Restored Endless hacks for Mega Man 2-3-4-5 that had been deleted by mistake.

## 2016-09-19

Added The Guardian Legend.

## 2016-09-18 #2

### Merged missing entries from the GameRandomizers Wikia

- Dragon Quest 4
- EarthBound
- Final Fantasy
- Final Fantasy III
- Final Fantasy V (abyssonym)
- Mega Man Battle Network 3
- Mega Man X
- Metroid Prime
- Metroid Prime 2: Echoes
- Mike Tyson's Punch-Out!!
- NES Open Tournament Golf
- Pokémon Red (Sanqui)
- Pokémon Trading Card Game
- Shining Force II
- Super Mario RPG
- Telefang Power Version

## 2016-09-18

Added Zelda II: The Adventure of Link.

## 2016-09-12

Added two Mega Man randomizers.

## 2016-08-28

Added Super Mario World.

## 2016-08-27

Initial list published on the ROMHacking.net forums.